/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.impl;

import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.map.hash.THashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.ILinkType;
import org.simantics.objmap.IMapping;
import org.simantics.objmap.IMappingListener;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.impl.Link;
import org.simantics.objmap.impl.RangeUpdateRequest;

public class Mapping
implements IMapping {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    IMappingSchema schema;
    THashMap<Resource, Link> domain = new THashMap();
    TCustomHashMap<Object, Link> range = new TCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);
    ArrayList<IMappingListener> listeners = new ArrayList();
    ArrayList<Link> modifiedDomainLinks = new ArrayList();
    ArrayList<Link> modifiedRangeLinks = new ArrayList();
    boolean disposed = false;
    boolean listensDomain;
    Set<Resource> domainSet = new AbstractSet<Resource>(){

        @Override
        public boolean add(Resource e) {
            if (Mapping.this.domain.containsKey((Object)e)) {
                return false;
            }
            Link link = new Link(null, e, null);
            Mapping.this.domain.put((Object)e, (Object)link);
            Mapping.this.modifiedDomainLinks.add(link);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return Mapping.this.domain.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Link link = (Link)Mapping.this.domain.remove(o);
            if (link == null) {
                return false;
            }
            Mapping.this.removeLink(link);
            if (link.rangeElement != null) {
                Mapping.this.range.remove(link.rangeElement);
            }
            return true;
        }

        @Override
        public Iterator<Resource> iterator() {
            return Mapping.this.domain.keySet().iterator();
        }

        @Override
        public int size() {
            return Mapping.this.domain.size();
        }
    };
    Set<Object> rangeSet = new AbstractSet<Object>(){

        @Override
        public boolean add(Object e) {
            if (Mapping.this.range.containsKey(e)) {
                return false;
            }
            Link link = new Link(null, null, e);
            Mapping.this.range.put(e, (Object)link);
            Mapping.this.modifiedRangeLinks.add(link);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return Mapping.this.range.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Link link = (Link)Mapping.this.range.remove(o);
            if (link == null) {
                return false;
            }
            Mapping.this.removeLink(link);
            if (link.domainElement != null) {
                Mapping.this.domain.remove((Object)link.domainElement);
            }
            return true;
        }

        @Override
        public Iterator<Object> iterator() {
            return Mapping.this.range.keySet().iterator();
        }

        @Override
        public int size() {
            return Mapping.this.range.size();
        }
    };

    public Mapping(IMappingSchema schema, boolean listensDomain) {
        this.schema = schema;
        this.listensDomain = listensDomain;
    }

    private void removeLink(Link link) {
        if (link.domainModified) {
            this.modifiedDomainLinks.remove(link);
        }
        if (link.rangeModified) {
            this.modifiedRangeLinks.remove(link);
        }
        link.removed = true;
    }

    private void createDomain(WriteGraph g, Link link) throws MappingException {
        LOGGER.info((Object)("        createDomain for " + link.rangeElement));
        ILinkType type = this.schema.linkTypeOfRangeElement(link.rangeElement);
        Resource domainElement = type.createDomainElement(g, link.rangeElement);
        link.type = type;
        link.domainElement = domainElement;
        this.domain.put((Object)domainElement, (Object)link);
        this.domainModified(link);
    }

    private void createRange(ReadGraph g, Link link) throws MappingException {
        ILinkType type = this.schema.linkTypeOfDomainElement(g, link.domainElement);
        Object rangeElement = type.createRangeElement(g, link.domainElement);
        link.type = type;
        link.rangeElement = rangeElement;
        this.range.put(rangeElement, (Object)link);
    }

    @Override
    public Set<Resource> getDomain() {
        return this.domainSet;
    }

    @Override
    public Set<Object> getRange() {
        return this.rangeSet;
    }

    @Override
    public synchronized Collection<Resource> updateDomain(WriteGraph g) throws MappingException {
        LOGGER.info((Object)"Mapping.updateDomain");
        RangeToDomain map = new RangeToDomain(g);
        ArrayList<Resource> updated = new ArrayList<Resource>();
        while (!this.modifiedRangeLinks.isEmpty()) {
            LOGGER.info((Object)("    modifiedRangeLinks.size() = " + this.modifiedRangeLinks.size()));
            Link link = this.modifiedRangeLinks.remove(this.modifiedRangeLinks.size() - 1);
            link.rangeModified = false;
            if (link.type == null) {
                this.createDomain(g, link);
            }
            if (!link.type.updateDomain(g, map, link.domainElement, link.rangeElement)) continue;
            updated.add(link.domainElement);
        }
        return updated;
    }

    @Override
    public synchronized Collection<Object> updateRange(ReadGraph g) throws MappingException {
        LOGGER.info((Object)"Mapping.updateRange");
        DomainToRange map = new DomainToRange(g);
        ArrayList<Object> updated = new ArrayList<Object>();
        while (!this.modifiedDomainLinks.isEmpty()) {
            LOGGER.info((Object)("    modifiedDomainLinks.size() = " + this.modifiedDomainLinks.size()));
            Link link = this.modifiedDomainLinks.remove(this.modifiedDomainLinks.size() - 1);
            link.domainModified = false;
            if (link.type == null) {
                this.createRange(g, link);
            }
            if (this.listensDomain) {
                RangeUpdateRequest request = new RangeUpdateRequest(link, map, this);
                try {
                    boolean modified = (Boolean)g.syncRequest((Read)request, (SyncListener)request);
                    if (!modified) continue;
                    updated.add(link.rangeElement);
                    continue;
                }
                catch (DatabaseException e) {
                    throw new MappingException(e);
                }
            }
            if (!link.type.updateRange(g, map, link.domainElement, link.rangeElement)) continue;
            updated.add(link.rangeElement);
        }
        return updated;
    }

    @Override
    public Object get(Resource domainElement) {
        Link link = (Link)this.domain.get((Object)domainElement);
        if (link == null) {
            return null;
        }
        return link.rangeElement;
    }

    @Override
    public Resource inverseGet(Object rangeElement) {
        Link link = (Link)this.range.get(rangeElement);
        if (link == null) {
            return null;
        }
        return link.domainElement;
    }

    @Override
    public Resource inverseMap(WriteGraph g, Object rangeElement) throws MappingException {
        this.getRange().add(rangeElement);
        this.updateDomain(g);
        return this.inverseGet(rangeElement);
    }

    @Override
    public Object map(ReadGraph g, Resource domainElement) throws MappingException {
        this.getDomain().add(domainElement);
        this.updateRange(g);
        return this.get(domainElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void domainModified(Link link) {
        if (!link.domainModified) {
            ArrayList<Link> arrayList = this.modifiedDomainLinks;
            synchronized (arrayList) {
                LOGGER.info((Object)("        domainModified for " + link.rangeElement));
                link.domainModified = true;
                this.modifiedDomainLinks.add(link);
                if (this.modifiedDomainLinks.size() == 1) {
                    for (IMappingListener listener : this.listeners) {
                        listener.domainModified();
                    }
                }
            }
        }
    }

    @Override
    public void domainModified(Resource domainElement) {
        Link link = (Link)this.domain.get((Object)domainElement);
        if (link != null) {
            this.domainModified(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rangeModified(Link link) {
        if (!link.rangeModified) {
            ArrayList<Link> arrayList = this.modifiedRangeLinks;
            synchronized (arrayList) {
                link.rangeModified = true;
                this.modifiedRangeLinks.add(link);
                if (this.modifiedRangeLinks.size() == 1) {
                    for (IMappingListener listener : this.listeners) {
                        listener.rangeModified();
                    }
                }
            }
        }
    }

    @Override
    public void rangeModified(Object rangeElement) {
        Link link = (Link)this.range.get(rangeElement);
        if (link != null) {
            this.rangeModified(link);
        }
    }

    @Override
    public boolean isDomainModified() {
        return !this.modifiedDomainLinks.isEmpty();
    }

    @Override
    public boolean isRangeModified() {
        return !this.modifiedRangeLinks.isEmpty();
    }

    @Override
    public void addMappingListener(IMappingListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMappingListener(IMappingListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<Resource> getConflictingDomainElements() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (this.modifiedDomainLinks.size() < this.modifiedRangeLinks.size()) {
            for (Link link : this.modifiedDomainLinks) {
                if (!link.rangeModified) continue;
                result.add(link.domainElement);
            }
        } else {
            for (Link link : this.modifiedRangeLinks) {
                if (!link.domainModified) continue;
                result.add(link.domainElement);
            }
        }
        return result;
    }

    @Override
    public Collection<Object> getConflictingRangeElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.modifiedDomainLinks.size() < this.modifiedRangeLinks.size()) {
            for (Link link : this.modifiedDomainLinks) {
                if (!link.rangeModified) continue;
                result.add(link.rangeElement);
            }
        } else {
            for (Link link : this.modifiedRangeLinks) {
                if (!link.domainModified) continue;
                result.add(link.rangeElement);
            }
        }
        return result;
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    class DomainToRange
    implements IFunction<Resource, Object> {
        ReadGraph g;

        public DomainToRange(ReadGraph g) {
            this.g = g;
        }

        @Override
        public Object get(Resource element) throws MappingException {
            Link link = (Link)Mapping.this.domain.get((Object)element);
            if (link == null) {
                link = new Link(null, element, null);
                link.domainModified = true;
                Mapping.this.modifiedDomainLinks.add(link);
                Mapping.this.domain.put((Object)element, (Object)link);
                Mapping.this.createRange(this.g, link);
            } else if (link.type == null) {
                Mapping.this.createRange(this.g, link);
            }
            return link.rangeElement;
        }
    }

    class RangeToDomain
    implements IFunction<Object, Resource> {
        WriteGraph g;

        public RangeToDomain(WriteGraph g) {
            this.g = g;
        }

        @Override
        public Resource get(Object element) throws MappingException {
            Link link = (Link)Mapping.this.range.get(element);
            if (link == null) {
                link = new Link(null, null, element);
                link.rangeModified = true;
                Mapping.this.modifiedRangeLinks.add(link);
                Mapping.this.range.put(element, (Object)link);
                Mapping.this.createDomain(this.g, link);
            } else if (link.type == null) {
                Mapping.this.createDomain(this.g, link);
            }
            return link.domainElement;
        }
    }
}

