/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.xyline;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.AxisHidePropertyComposite;
import org.simantics.jfreechart.chart.properties.BooleanPropertyFactory;
import org.simantics.jfreechart.chart.properties.BooleanSelectionListener;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.jfreechart.chart.properties.RVIFactory;
import org.simantics.jfreechart.chart.properties.RVIModifier;
import org.simantics.jfreechart.chart.properties.TitleFactory;
import org.simantics.jfreechart.chart.properties.TitleModifier;
import org.simantics.jfreechart.chart.properties.VariableExistsValidator;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class XYLineGeneralPropertiesTab
extends AdjustableTab
implements Widget {
    private ScrolledComposite sc;
    private TrackedText name;
    private TrackedText title;
    private TrackedText xlabel;
    private TrackedText xvariable;
    private TrackedText xmin;
    private TrackedText xmax;
    private TrackedCombo type;
    private Button hgrid;
    private Button htitle;
    private Button hlegend;
    private WidgetSupportImpl domainAxisSupport = new WidgetSupportImpl();
    private Group general;
    private Label nameLabel;
    private Label labelTitle;
    private Label labelType;
    private Group hideGroup;
    private Group xgroup;
    private Label xVariableLabel;
    private Label labelMin;
    private AxisHidePropertyComposite axisHide;
    private Label labelLabel;
    private Label labelMax;
    private Composite xColumn1;
    private Composite xColumn2;

    public XYLineGeneralPropertiesTab(Object id) {
        super(id);
    }

    public void setInput(final ISessionContext context, Object input) {
        final Resource chart = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (chart == null) {
            return;
        }
        context.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.Plot));
                if (plot == null) {
                    return;
                }
                final Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
                if (domainAxis == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XYLineGeneralPropertiesTab.this.domainAxisSupport.fireInput(context, (Object)new StructuredSelection((Object)domainAxis));
                    }
                });
            }
        });
    }

    @Override
    protected void createAndAddControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        this.sc = new ScrolledComposite(body, 768);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.composite = new Composite((Composite)this.sc, 0);
        this.general = new Group(this.composite, 0);
        this.general.setText("General");
        this.nameLabel = new Label((Composite)this.general, 0);
        this.nameLabel.setText("Name:");
        this.nameLabel.setAlignment(131072);
        this.name = new TrackedText((Composite)this.general, support, 2048);
        this.name.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.name.getResourceManager()));
        this.labelType = new Label((Composite)this.general, 0);
        this.labelType.setText("Type:");
        this.type = new TrackedCombo((Composite)this.general, support, 2056);
        this.type.addModifyListener((TextModifyListener)new TypeModifyListener());
        this.type.setItemFactory((ReadFactory)new TypeItemFactory());
        this.type.setSelectionFactory((ReadFactory)new TypeSelectionFactory());
        this.labelTitle = new Label((Composite)this.general, 0);
        this.labelTitle.setText("Title:");
        this.title = new TrackedText((Composite)this.general, support, 2048);
        this.title.setTextFactory((ReadFactory)new TitleFactory());
        this.title.addModifyListener((TextModifyListener)new TitleModifier());
        this.title.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.name.getResourceManager()));
        this.hideGroup = new Group(this.composite, 0);
        this.hideGroup.setText("Hide");
        this.hgrid = new Button((Composite)this.hideGroup, support, 32);
        this.hgrid.setText("Grid");
        this.hgrid.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Plot/visibleGrid", true));
        this.hgrid.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, "http://www.simantics.org/JFreeChart-1.0/Plot", "http://www.simantics.org/JFreeChart-1.0/Plot/visibleGrid", true));
        this.htitle = new Button((Composite)this.hideGroup, support, 32);
        this.htitle.setText("Title");
        this.htitle.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/JFreeChart-1.0/TextTitle", "http://www.simantics.org/JFreeChart-1.0/visible", true));
        this.htitle.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, "http://www.simantics.org/JFreeChart-1.0/TextTitle", "http://www.simantics.org/JFreeChart-1.0/visible", true));
        this.hlegend = new Button((Composite)this.hideGroup, support, 32);
        this.hlegend.setText("Legend");
        this.hlegend.setSelectionFactory((ReadFactory)new BooleanPropertyFactory(null, "http://www.simantics.org/JFreeChart-1.0/Chart/visibleLegend", true));
        this.hlegend.addSelectionListener((SelectionListener)new BooleanSelectionListener(context, null, "http://www.simantics.org/JFreeChart-1.0/Chart/visibleLegend", true));
        this.xgroup = new Group(this.composite, 0);
        this.xgroup.setText("X-axis");
        this.xColumn1 = new Composite((Composite)this.xgroup, 0);
        this.xVariableLabel = new Label(this.xColumn1, 0);
        this.xVariableLabel.setText("Variable:");
        this.xvariable = new TrackedText(this.xColumn1, (WidgetSupport)this.domainAxisSupport, 2048);
        this.xvariable.setTextFactory((ReadFactory)new RVIFactory());
        this.xvariable.addModifyListener((TextModifyListener)new RVIModifier((Control)this.xvariable.getWidget(), (WidgetSupport)this.domainAxisSupport));
        this.xvariable.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.xvariable.getResourceManager()));
        this.xvariable.setInputValidator((IInputValidator)new VariableExistsValidator(support, this.xvariable, true));
        this.labelLabel = new Label(this.xColumn1, 0);
        this.labelLabel.setText("Label:");
        this.xlabel = new TrackedText(this.xColumn1, (WidgetSupport)this.domainAxisSupport, 2048);
        this.xlabel.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel", ""));
        this.xlabel.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.xlabel.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.xlabel.getResourceManager()));
        this.xColumn2 = new Composite((Composite)this.xgroup, 0);
        this.labelMin = new Label(this.xColumn2, 0);
        this.labelMin.setText("Min:");
        this.labelMin.setAlignment(131072);
        this.xmin = new TrackedText(this.xColumn2, (WidgetSupport)this.domainAxisSupport, 2048);
        this.xmin.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.xmin.getResourceManager()));
        this.xmin.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/JFreeChart-1.0/Axis/min"));
        this.xmin.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/JFreeChart-1.0/Axis/min"));
        this.xmin.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.labelMax = new Label(this.xColumn2, 0);
        this.labelMax.setText("Max:");
        this.xmax = new TrackedText(this.xColumn2, (WidgetSupport)this.domainAxisSupport, 2048);
        this.xmax.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(this.xmax.getResourceManager()));
        this.xmax.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/JFreeChart-1.0/Axis/max"));
        this.xmax.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/JFreeChart-1.0/Axis/max"));
        this.xmax.setInputValidator((IInputValidator)new DoubleValidator(true));
        this.axisHide = new AxisHidePropertyComposite(this.composite, context, (WidgetSupport)this.domainAxisSupport, 0);
        this.sc.setContent((Control)this.composite);
    }

    @Override
    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.general);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.general);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.nameLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelType);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelTitle);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, false).applyTo((Control)this.title.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.hideGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.hideGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xgroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo((Composite)this.xgroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xColumn1);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.xColumn1);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.xVariableLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xvariable.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xlabel.getWidget());
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.xColumn2);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMin);
        GridDataFactory.fillDefaults().applyTo((Control)this.xmin.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMax);
        GridDataFactory.fillDefaults().applyTo((Control)this.xmax.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide);
        this.composite.layout();
        GridDataFactory.fillDefaults().hint(this.xVariableLabel.getBounds().width, -1).align(0x1000008, 0x1000000).applyTo((Control)this.nameLabel);
        GridDataFactory.fillDefaults().hint(this.xVariableLabel.getBounds().width, -1).align(0x1000008, 0x1000000).applyTo((Control)this.labelMin);
        Point size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(size);
    }

    @Override
    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.sc);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.general);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(4).applyTo((Composite)this.general);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.nameLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelType);
        GridDataFactory.fillDefaults().applyTo((Control)this.type.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelTitle);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.title.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.hideGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.hideGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xgroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this.xgroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xColumn1);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.xColumn1);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.xVariableLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xvariable.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.xlabel.getWidget());
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(this.xColumn2);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMin);
        GridDataFactory.fillDefaults().applyTo((Control)this.xmin.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelMax);
        GridDataFactory.fillDefaults().applyTo((Control)this.xmax.getWidget());
        GridDataFactory.fillDefaults().applyTo((Control)this.axisHide);
        this.composite.layout();
        GridDataFactory.fillDefaults().hint(this.xVariableLabel.getBounds().width, -1).align(0x1000008, 0x1000000).applyTo((Control)this.nameLabel);
        Point size = this.composite.computeSize(-1, -1);
        this.sc.setMinSize(size);
    }

    private class TypeItemFactory
    extends ReadFactoryImpl<Resource, Map<String, Object>> {
        private TypeItemFactory() {
        }

        public Map<String, Object> perform(ReadGraph graph, Resource series) throws DatabaseException {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("Line", "Line");
            result.put("Area", "Area");
            return result;
        }
    }

    private class TypeModifyListener
    extends ComboModifyListenerImpl<Resource> {
        private TypeModifyListener() {
        }

        public void applyText(WriteGraph graph, Resource chart, String text) throws DatabaseException {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.XYPlot));
            if (plot == null) {
                return;
            }
            Collection datasets = (Collection)graph.syncRequest((Read)new ObjectsWithType(plot, l0.ConsistsOf, jfree.XYDataset));
            if (datasets == null || datasets.isEmpty()) {
                return;
            }
            for (Resource dataset : datasets) {
                graph.deny(dataset, jfree.Dataset_renderer);
                Resource renderer = text.equals("Area") ? GraphUtils.create2((WriteGraph)graph, (Resource)jfree.XYAreaRenderer, (Object[])new Object[0]) : GraphUtils.create2((WriteGraph)graph, (Resource)jfree.XYLineRenderer, (Object[])new Object[0]);
                graph.claim(dataset, jfree.Dataset_renderer, renderer);
            }
        }
    }

    private class TypeSelectionFactory
    extends ReadFactoryImpl<Resource, String> {
        private TypeSelectionFactory() {
        }

        public String perform(ReadGraph graph, Resource chart) throws DatabaseException {
            Resource renderer;
            Resource dataset;
            Collection datasets;
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.XYPlot));
            if (plot != null && !(datasets = (Collection)graph.syncRequest((Read)new ObjectsWithType(plot, l0.ConsistsOf, jfree.XYDataset))).isEmpty() && (dataset = (Resource)datasets.iterator().next()) != null && (renderer = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(dataset, jfree.Dataset_renderer, jfree.Renderer))) != null && graph.isInstanceOf(renderer, jfree.XYAreaRenderer)) {
                return "Area";
            }
            return "Line";
        }
    }
}

