/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AllVariablesOfModel;
import org.simantics.jfreechart.chart.properties.ChartVariable;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class VariableExistsValidator
implements IInputValidator,
Widget {
    protected Collection<ChartVariable> variables;
    protected TrackedText text;
    private boolean allowEmpty;
    private boolean useLabels = false;

    public VariableExistsValidator(WidgetSupport support, TrackedText text) {
        this(support, text, false);
    }

    public VariableExistsValidator(WidgetSupport support, TrackedText text, boolean allowEmpty) {
        support.register((Widget)this);
        this.variables = new ArrayList<ChartVariable>();
        this.text = text;
        this.allowEmpty = allowEmpty;
    }

    public VariableExistsValidator(WidgetSupport support, TrackedText text, boolean allowEmpty, boolean useLabels) {
        this(support, text, allowEmpty);
        this.useLabels = useLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String isValid(String newText) {
        if (newText == null || newText.isEmpty()) {
            if (!this.allowEmpty) return "Empty name not allowed";
            return null;
        }
        Collection<ChartVariable> collection = this.variables;
        synchronized (collection) {
            ChartVariable variable;
            Iterator<ChartVariable> iterator = this.variables.iterator();
            do {
                if (!iterator.hasNext()) {
                    return "Not a valid variable name";
                }
                variable = iterator.next();
                if (!newText.equals(variable.getLabel())) continue;
                return null;
            } while (!newText.equals(variable.getRvi()));
            return null;
        }
    }

    public void setInput(ISessionContext context, Object input) {
        Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (resource == null) {
            this.variables = new ArrayList<ChartVariable>();
            return;
        }
        try {
            AllVariablesOfModel query = AllVariablesOfModel.withRandomResource(context, resource);
            if (query != null) {
                SimanticsUI.getSession().asyncRequest((Read)query, (Listener)new Listener<Collection<ChartVariable>>(){

                    public void execute(Collection<ChartVariable> variables) {
                        VariableExistsValidator.this.variables = variables;
                    }

                    public void exception(Throwable t) {
                        t.printStackTrace();
                    }

                    public boolean isDisposed() {
                        return VariableExistsValidator.this.text.isDisposed();
                    }
                });
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
}

