/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart;

import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.Resource;
import org.simantics.jfreechart.ChartPanel;
import org.simantics.jfreechart.ChartPanelElement;
import org.simantics.utils.ui.AdaptionUtils;

public class ChartDropTarget
extends DropTargetAdapter {
    private Composite separator;
    private ChartPanelElement element;
    private Display display;
    private ChartPanel panel;

    public ChartDropTarget(Composite separator, ChartPanelElement element, ChartPanel panel) {
        this.separator = separator;
        this.display = separator.getDisplay();
        this.element = element;
        this.panel = panel;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
        this.separator.setBackground(this.display.getSystemColor(16));
    }

    public void dragLeave(DropTargetEvent event) {
        this.separator.setBackground(this.display.getSystemColor(22));
    }

    public void drop(DropTargetEvent event) {
        Resource chartResource = (Resource)AdaptionUtils.adaptToSingle((Object)event.data, Resource.class);
        if (chartResource != null) {
            this.panel.addChart(chartResource, this.element);
        }
    }
}

