/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.Parser;
import fi.semantum.sysdyn.solver.parser.ModelParser;
import fi.semantum.sysdyn.solver.parser.ParseException;
import fi.semantum.sysdyn.solver.parser.SimpleNode;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class CodeCache {
    static final int CACHE_SIZE = 5;
    private static CodeCache INSTANCE;
    final Map<String, Model> models = new HashMap<String, Model>();
    final LinkedList<String> codes = new LinkedList();

    public static CodeCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CodeCache();
        }
        return INSTANCE;
    }

    private CodeCache() {
    }

    public Model getModel(String code) throws ParseException {
        Model model = this.models.get(code);
        if (model == null) {
            StringReader reader = new StringReader(code);
            ModelParser modelParser = new ModelParser(reader);
            SimpleNode n = (SimpleNode)modelParser.stored_definition();
            Parser parser = new Parser();
            model = new Model(new Model.Globals(), "", false);
            parser.walk(n, 0, model);
            model.prepare();
            model.prepareFunctions();
            model.sortAssignments();
            this.models.put(code, model);
            if (this.codes.size() == 5) {
                String last = this.codes.removeLast();
                this.models.remove(last);
                this.codes.addFirst(code);
            }
        }
        return model;
    }
}

