/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.contributions.search;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.SearchQuery;

/**
 * @author Tuukka Lehtonen
 */
public class SearchTrim extends Composite {

    private static final String SEARCH_TEXT_FOCUS_CONTROL_ID = "org.simantics.workbench.search.text";

	

    public static final String         KEY_TRIM    = "SearchTrim";

   

    private final LocalResourceManager resourceManager;

    private final boolean              disabled    = false;

    protected final Text                 searchText;

    /**
     * Creates a new heap status control with the given parent, and using the
     * given preference store to obtain settings such as the refresh interval.
     * 
     * @param parent the parent composite
     * @param prefStore the preference store
     */
    public SearchTrim(Composite parent) {
        super(parent, SWT.NONE);

        // System.err.println("parent: " + parent.getLayout());
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), this);

        searchText = new Text(this, SWT.BORDER | SWT.FLAT | SWT.SEARCH | SWT.ICON_SEARCH);
        searchText.setToolTipText("Enter Search Criteria for Active Model");
        GridDataFactory.fillDefaults().hint(100, SWT.DEFAULT).grab(true, true).applyTo(searchText);
        searchText.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.CR || e.keyCode == SWT.KEYPAD_CR) {
                    nameAndTypeQuery(((e.stateMask & SWT.CTRL) == 0) ? ISearchService.ResultBrowser.VIEW : ISearchService.ResultBrowser.EDITOR);
                }
            }
        });

        if (PlatformUI.isWorkbenchRunning()) {
            IFocusService service = (IFocusService) PlatformUI.getWorkbench().getService(IFocusService.class);
            service.addFocusTracker(searchText, SEARCH_TEXT_FOCUS_CONTROL_ID);
        }

        if ((searchText.getStyle() & SWT.ICON_SEARCH) == 0) {
            final Label searchButton= new Label(this, SWT.NONE);
            searchButton.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, true));
            searchButton.setImage((Image) resourceManager.get(BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "/icons/magnifier.png")));
            searchButton.moveAbove(searchText);
            searchButton.setToolTipText("Search Active Model Contents");

            GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).numColumns(3).applyTo(this);
        } else {
            GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).numColumns(2).applyTo(this);
        }

        Label filler = new Label(this, SWT.NONE);
        GridDataFactory.swtDefaults().grab(true, false).minSize(3, SWT.DEFAULT).applyTo(filler);

        /*

        final Button b = new Button(this, SWT.PUSH);
        // b.setText("Search by Name");
        b.setText("&Name");
        b.setToolTipText("Search by Name");
        b.setImage(resourceManager.createImage(Activator.getImageDescriptor("img/magnifier.png")));
        GridDataFactory.fillDefaults().applyTo(b);
        b.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                nameQuery(((e.stateMask & SWT.CTRL) == 0) ? ResultBrowser.VIEW : ResultBrowser.EDITOR);
            }
        });

        final Button b2 = new Button(this, SWT.PUSH);
        b2.setText("&Type");
        // b2.setText("Search by Type");
        b2.setToolTipText("Search by Type");
        GridDataFactory.fillDefaults().applyTo(b2);

        b2.setImage(resourceManager.createImage(Activator.getImageDescriptor("img/magnifier.png")));
        b2.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                typeQuery(((e.stateMask & SWT.CTRL) == 0) ? ResultBrowser.VIEW : ResultBrowser.EDITOR);
            }
        });
        */

        // Register the KEY_TRIM datum into this controls parent Shell.
        // This enables FocusSearchTrim handler to work (to focus this control).
        final Shell shell = parent.getShell();
        shell.setData(KEY_TRIM, searchText);
        addDisposeListener(new DisposeListener() {
            @Override
            public void widgetDisposed(DisposeEvent e) {
                shell.setData(KEY_TRIM, null);
            }
        });
    }

    protected void nameQuery(ISearchService.ResultBrowser browserType) {
        if (disabled)
            return;
        String originalInput = searchText.getText();
        String query = originalInput;

        // Don't allow empty queries
        if (query.trim().isEmpty())
            return;

        query = filter(query);

        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("Name", "on");
        performQuery(searchQuery, browserType);
    }

    protected void typeQuery(ISearchService.ResultBrowser browserType) {
        if (disabled)
            return;
        String originalInput = searchText.getText();
        String query = originalInput;

        // Don't allow empty queries
        if (query.trim().isEmpty())
            return;
        
        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("Types", "on");
        performQuery(searchQuery, browserType);
    }

    protected void nameAndTypeQuery(ISearchService.ResultBrowser browserType) {
        if (disabled)
            return;
        String originalInput = searchText.getText();
        String query = originalInput;

        // Don't allow empty queries
        if (query.trim().isEmpty())
            return;

        SearchQuery searchQuery = new SearchQuery(originalInput);
        searchQuery.setSearchFlag("Name", "on");
        searchQuery.setSearchFlag("Types", "on");
        performQuery(searchQuery, browserType);
    }

    protected String filter(String query) {
        // TODO: implement
        if (!query.endsWith("*"))
            query += "*";
        // ''' characters cannot be used in the query string, replace them with '"'
        query = query.replaceAll("'", "\"");
        return query;
    }

    protected void performQuery(SearchQuery query, ISearchService.ResultBrowser browserType) {
    	ISearchService searchService = (ISearchService)PlatformUI.getWorkbench().getService(ISearchService.class);
    	searchService.performQuery(query, browserType, true);
    }

   
    


}