/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal;

import org.eclipse.core.runtime.NullProgressMonitor;

/**
 * @author Tuukka Lehtonen
 */
class TimingProgressMonitor extends NullProgressMonitor {

    private final long start;

    public TimingProgressMonitor() {
        this.start = System.nanoTime();
    }

    @Override
    public void worked(int work) {
        System.out.println("worked(" + work + ") @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void subTask(String name) {
        System.out.println("subTask(" + name + ") @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void setTaskName(String name) {
        System.out.println("setTaskName(" + name + ") @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void setCanceled(boolean value) {
        System.out.println("setCanceled(" + value+ ") @ " + (System.nanoTime() - start)*1e-9);
        super.setCanceled(value);
    }

    @Override
    public boolean isCanceled() {
        System.out.println("isCanceled() @ " + (System.nanoTime() - start)*1e-9);
        return super.isCanceled();
    }

    @Override
    public void internalWorked(double work) {
        System.out.println("internalWorked(" + work + ") @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void done() {
        System.out.println("done() @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void beginTask(String name, int totalWork) {
        System.out.println("beginTask(" + name + ", " + totalWork + ") @ " + (System.nanoTime() - start)*1e-9);
    }

}