package org.simantics.scl.compiler.source;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.module.repository.UpdateListener;

public class StringModuleSource extends TextualModuleSource {
    private final String moduleText;
    private final ClassLoader classLoader;

    public StringModuleSource(String moduleName, ClassLoader classLoader, String moduleText) {
        super(moduleName);
        this.classLoader = classLoader;
        this.moduleText = moduleText;
    }

    public StringModuleSource(String moduleName, String moduleText) {
        this(moduleName, StringModuleSource.class.getClassLoader(), moduleText);
    }
    
    @Override
    protected Reader getSourceReader(UpdateListener listener)
            throws IOException {
        return new StringReader(moduleText);
    }
    
    @Override
    public ClassLoader getClassLoader() {
        return classLoader;
    }

    @Override
    protected JavaReferenceValidator<?, ?, ?, ?> getJavaReferenceValidator() {
        return new RuntimeJavaReferenceValidator(getClassLoader());
    }
}
