package org.simantics.scl.compiler.source;

import java.io.IOException;
import java.io.InputStream;

import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidator;
import org.simantics.scl.compiler.internal.codegen.types.RuntimeJavaReferenceValidator;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.UpdateListener;

public class ClassModuleSource extends EncodedTextualModuleSource {
    private final Class<?> clazz;
    private final String path;
    private final ClassLoader classLoader;
    private final ImportDeclaration[] builtinImports;
    
    public ClassModuleSource(String moduleName, Class<?> clazz, ClassLoader classLoader, String path, ImportDeclaration[] builtinImports) {
        super(moduleName);
        this.clazz = clazz;
        this.classLoader = classLoader;
        this.path = path;
        this.builtinImports = builtinImports;
    }

    @Override
    protected InputStream getSourceStream(UpdateListener listener)
            throws IOException {
        return clazz.getResourceAsStream(path);
    }

    @Override
    protected JavaReferenceValidator<?, ?, ?, ?> getJavaReferenceValidator() {
        return new RuntimeJavaReferenceValidator(classLoader);
    }
    
    @Override
    protected ImportDeclaration[] getBuiltinImports(UpdateListener listener) {
        return builtinImports;
    }
}
