package org.simantics.scl.compiler.parser.regexp;

import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public class RAtom extends Regexp {
    public final int symbolId;

    public RAtom(int symbolId) {
        this.symbolId = symbolId;
    }

    @Override
    protected void buildAutomaton(NFA aut, int inState, int outState) {
        aut.addTransition(inState, symbolId, outState);
    }

    @Override
    protected void toString(StringBuilder b, int prec) {
        b.append((char)symbolId);
    }

    @Override
    public void toString(StringBuilder b, Namer grammar, int prec) {
        if(symbolId == 0x80000000)
            b.append("#");
        else
            b.append(grammar.getName(symbolId));
    }
    
    @Override
    protected int getTypeId() {
        return ATOM;
    }
    
    @Override
    public boolean equals(Object obj) {
        if(obj == this)
            return true;
        if(obj == null || obj.getClass() != getClass())
            return false;
        RAtom other = (RAtom)obj;
        return symbolId == other.symbolId;
    }
    
    @Override
    public int hashCode() {
        return 31*symbolId + 46;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

}
