package org.simantics.scl.compiler.parser.generator.grammar;

import org.simantics.scl.compiler.parser.regexp.automata.DFA;

import gnu.trove.map.hash.TIntByteHashMap;

public class Prod {
    public final String name;
    public final int lhs;
    public final DFA rhs;
    public final TIntByteHashMap annotations;
    
    public Prod(String name, int lhs, DFA rhs, TIntByteHashMap annotations) {
        this.name = name;
        this.lhs = lhs;
        this.rhs = rhs;
        this.annotations = annotations;
    }

    public String toString(AnaGrammar grammar) {
        StringBuilder b = new StringBuilder();
        b.append(grammar.nonterminalNames[lhs]);
        b.append(" ::= ");
        rhs.toRegexp().toString(b, grammar, 0);
        return b.toString();
    }
}