package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class LinkNode extends Node {
    public String label;
    public String url;
    public String title;
    
    public LinkNode(String label, String url, String title) {
        this.label = label;
        this.url = url;
        this.title = title;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        b.append("<a href=\"").append(HtmlEscape.escapeURL(url));
        if(title.isEmpty())
            b.append("\">");
        else {
            b.append("\" title=\"");
            b.append(HtmlEscape.escape(title));
            b.append("\">");
        }
        super.toHtml(b);
        b.append("</a>");
    }
}
