/* The following code was generated by JFlex 1.6.1 */

package org.simantics.scl.compiler.internal.parsing.parser;

import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.exceptions.SCLSyntaxErrorException;
import gnu.trove.list.array.TIntArrayList;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.6.1
 * from the specification file <tt>C:/Users/hannu/git/scl/org.simantics.scl.compiler/src/org/simantics/scl/compiler/internal/parsing/parser/SCLLexer.flex</tt>
 */
public class SCLLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int STRING = 2;
  public static final int LONG_STRING = 4;
  public static final int CHAR = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3, 3
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\75\1\74\1\73\1\73\1\15\22\0\1\24\1\20\1\71"+
    "\1\6\2\5\1\20\1\4\1\11\1\13\1\26\1\5\1\12\1\23"+
    "\1\7\1\25\12\2\1\66\1\67\1\17\1\65\1\21\1\14\1\10"+
    "\4\3\1\22\1\3\3\1\1\60\20\1\1\63\1\30\1\64\1\5"+
    "\1\72\1\16\1\34\1\46\1\47\1\51\1\41\1\31\1\54\1\40"+
    "\1\36\2\1\1\35\1\52\1\42\1\32\1\53\1\55\1\33\1\43"+
    "\1\37\1\45\1\56\1\44\1\50\1\57\1\1\1\61\1\70\1\62"+
    "\1\5\6\0\1\73\u1fa2\0\1\73\1\73\udfd3\0\1\27\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\22\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\1\2\1\3\1\1\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\1\1\13\1\1\1\14"+
    "\1\15\1\16\1\17\1\4\1\20\1\21\16\2\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\13\1\34\1\35\1\36\1\0\1\37\1\36"+
    "\1\40\2\35\2\40\5\0\1\4\1\41\1\42\1\43"+
    "\3\0\1\2\4\0\1\4\1\44\1\45\1\46\1\4"+
    "\2\0\2\2\1\47\2\2\1\50\1\51\11\2\1\52"+
    "\3\2\1\53\2\2\1\54\4\2\1\55\1\56\1\57"+
    "\1\0\1\60\1\61\1\62\1\63\1\64\1\60\1\65"+
    "\2\0\2\66\1\0\1\67\1\70\1\2\1\0\1\71"+
    "\2\0\2\72\1\0\1\4\1\0\3\2\1\73\25\2"+
    "\1\74\1\75\1\0\1\76\2\0\1\46\1\0\1\2"+
    "\1\77\6\2\1\100\1\101\2\2\1\102\3\2\1\103"+
    "\1\2\1\104\2\2\1\105\3\2\1\0\1\46\1\0"+
    "\2\2\1\106\11\2\1\107\1\2\1\110\1\2\1\111"+
    "\1\2\1\0\1\112\1\113\1\2\1\114\1\115\2\2"+
    "\1\116\1\2\1\117\1\120\2\2\1\121\3\2\1\122"+
    "\2\2\1\123\2\2\1\124\1\125\1\0\4\2\1\126"+
    "\2\2\2\0\1\2\1\127\2\0\2\2\2\0\1\2"+
    "\2\0\1\130\1\2\2\0\1\131\2\0\1\2\4\0"+
    "\1\2\1\132\2\0\1\133\1\2\2\0\1\134\2\0"+
    "\1\135\1\0\1\136";

  private static int [] zzUnpackAction() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\76\0\174\0\272\0\272\0\370\0\u0136\0\u0174"+
    "\0\u01b2\0\u01f0\0\u022e\0\u026c\0\u02aa\0\272\0\272\0\u02e8"+
    "\0\u0326\0\u0364\0\u03a2\0\u01b2\0\u03e0\0\u041e\0\u045c\0\272"+
    "\0\u049a\0\u04d8\0\u0516\0\u0554\0\u0592\0\u05d0\0\u060e\0\u064c"+
    "\0\u068a\0\u06c8\0\u0706\0\u0744\0\u0782\0\u07c0\0\u07fe\0\272"+
    "\0\272\0\272\0\272\0\u083c\0\u087a\0\272\0\u01b2\0\u08b8"+
    "\0\370\0\272\0\272\0\u08f6\0\u0934\0\u0972\0\272\0\272"+
    "\0\u09b0\0\u09ee\0\u0a2c\0\u08f6\0\272\0\u0a6a\0\u0aa8\0\u0ae6"+
    "\0\u0b24\0\u0b62\0\u0ba0\0\272\0\u0bde\0\u0c1c\0\u0c5a\0\u0c98"+
    "\0\u0cd6\0\u0d14\0\u0d52\0\u0d90\0\u0dce\0\u0e0c\0\u0e4a\0\u01b2"+
    "\0\u01b2\0\u0e88\0\u0ec6\0\u0f04\0\u0f42\0\u0f80\0\u0fbe\0\370"+
    "\0\u0ffc\0\u103a\0\370\0\u1078\0\u10b6\0\u10f4\0\u1132\0\u1170"+
    "\0\u11ae\0\u11ec\0\u122a\0\u1268\0\u12a6\0\370\0\u12e4\0\u1322"+
    "\0\u1360\0\370\0\u139e\0\u13dc\0\370\0\u141a\0\u1458\0\u1496"+
    "\0\u14d4\0\u01b2\0\u01b2\0\u01b2\0\u1512\0\272\0\272\0\272"+
    "\0\272\0\272\0\u1550\0\272\0\u158e\0\u02e8\0\u15cc\0\u160a"+
    "\0\u160a\0\272\0\272\0\272\0\u1648\0\272\0\u1686\0\u16c4"+
    "\0\272\0\u01b2\0\u1702\0\u1740\0\u177e\0\u17bc\0\u17fa\0\u1838"+
    "\0\370\0\u1876\0\u18b4\0\u18f2\0\u1930\0\u196e\0\u19ac\0\u19ea"+
    "\0\u1a28\0\u1a66\0\u1aa4\0\u1ae2\0\u1b20\0\u1b5e\0\u1b9c\0\u1bda"+
    "\0\u1c18\0\u1c56\0\u1c94\0\u1cd2\0\u1d10\0\u1d4e\0\370\0\272"+
    "\0\u1d8c\0\272\0\u1dca\0\u1e08\0\u01b2\0\u1e46\0\u1e84\0\370"+
    "\0\u1ec2\0\u1f00\0\u1f3e\0\u1f7c\0\u1fba\0\u1ff8\0\370\0\370"+
    "\0\u2036\0\u2074\0\370\0\u20b2\0\u20f0\0\u212e\0\370\0\u216c"+
    "\0\370\0\u21aa\0\u21e8\0\370\0\u2226\0\u2264\0\u22a2\0\u22e0"+
    "\0\272\0\u231e\0\u235c\0\u239a\0\u23d8\0\u2416\0\u2454\0\u2492"+
    "\0\u24d0\0\u250e\0\u254c\0\u258a\0\u25c8\0\u2606\0\370\0\u2644"+
    "\0\370\0\u2682\0\370\0\u26c0\0\u26fe\0\272\0\370\0\u273c"+
    "\0\370\0\370\0\u277a\0\u27b8\0\u27f6\0\u2834\0\370\0\370"+
    "\0\u2872\0\u28b0\0\u28ee\0\u292c\0\u296a\0\u29a8\0\272\0\u29e6"+
    "\0\u2a24\0\370\0\u2a62\0\u2aa0\0\370\0\370\0\u2ade\0\u2b1c"+
    "\0\u2b5a\0\u2b98\0\u2bd6\0\370\0\u2c14\0\u2c52\0\u2c90\0\u2cce"+
    "\0\u2d0c\0\370\0\u2d4a\0\u2d88\0\u2dc6\0\u2e04\0\u2e42\0\u2e80"+
    "\0\u2ebe\0\u2efc\0\u2f3a\0\370\0\u2f78\0\u2fb6\0\u2ff4\0\370"+
    "\0\u3032\0\u3070\0\u30ae\0\u30ec\0\u312a\0\u3168\0\u31a6\0\u31e4"+
    "\0\272\0\u3222\0\u3260\0\272\0\u329e\0\u32dc\0\u331a\0\370"+
    "\0\u3358\0\u3396\0\272\0\u33d4\0\272";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\1\7\1\6\1\10\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\11\1\24\1\6\1\25\1\26\1\27\1\11\1\30"+
    "\1\31\1\32\1\6\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\6\1\42\1\43\1\6\1\44\1\45"+
    "\1\6\1\46\1\47\6\6\1\50\1\51\1\52\1\53"+
    "\1\54\1\55\1\56\1\57\1\60\1\61\2\62\1\63"+
    "\15\64\1\65\11\64\1\30\1\66\40\64\1\67\2\64"+
    "\1\70\16\64\1\71\11\64\1\30\1\72\40\64\1\73"+
    "\1\64\1\74\1\75\1\64\77\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\30\6\11\0\1\6\5\0\1\7"+
    "\4\0\1\77\12\0\1\100\16\0\1\100\34\0\4\101"+
    "\1\0\22\101\1\0\1\102\45\101\5\0\2\11\1\0"+
    "\1\11\6\0\3\11\1\0\1\11\1\0\2\11\1\0"+
    "\1\11\34\0\2\11\1\0\1\11\12\0\2\11\1\0"+
    "\1\11\4\0\1\103\1\0\3\11\1\0\1\11\1\103"+
    "\2\11\1\0\1\11\34\0\2\11\1\0\1\11\3\0"+
    "\1\103\10\0\1\104\5\0\1\105\6\0\1\105\47\0"+
    "\1\105\2\0\1\106\1\0\1\106\1\0\2\11\1\0"+
    "\1\11\6\0\3\11\1\106\1\11\1\0\2\11\1\0"+
    "\1\11\30\106\4\0\2\11\1\0\1\11\1\0\1\106"+
    "\10\0\2\107\1\110\1\107\1\0\1\111\4\0\3\107"+
    "\1\0\1\107\1\0\2\107\1\0\1\107\34\0\2\107"+
    "\1\0\1\107\6\0\1\112\1\0\1\112\16\0\1\112"+
    "\6\0\30\112\11\0\1\112\77\0\1\62\2\0\1\113"+
    "\1\0\1\113\5\0\1\114\2\0\1\115\5\0\1\113"+
    "\6\0\30\113\11\0\1\113\10\0\2\11\1\0\1\11"+
    "\3\0\1\116\2\0\1\11\1\117\1\11\1\0\1\120"+
    "\1\0\2\11\1\0\1\11\34\0\2\11\1\0\1\117"+
    "\12\0\2\11\1\0\1\11\6\0\2\11\1\121\1\0"+
    "\1\11\1\0\2\11\1\0\1\11\34\0\2\11\1\0"+
    "\1\11\31\0\1\26\56\0\2\11\1\0\1\11\6\0"+
    "\3\11\1\0\1\11\1\0\1\122\1\123\1\0\1\11"+
    "\34\0\2\11\1\0\1\11\12\0\2\11\1\0\1\11"+
    "\6\0\3\11\1\0\1\11\1\124\2\11\1\0\1\11"+
    "\21\0\1\125\12\0\2\11\1\0\1\11\6\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\1\6\1\126\26\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\14\6\1\127\13\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\12\6\1\130\2\6"+
    "\1\131\12\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\10\6\1\132\17\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\1\133"+
    "\10\6\1\134\7\6\1\135\6\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\2\6\1\136"+
    "\4\6\1\137\16\6\1\140\1\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\5\6\1\141"+
    "\22\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\1\142\3\6\1\143\4\6\1\144\5\6"+
    "\1\145\4\6\1\146\3\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\10\6\1\147\17\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\5\6\1\150\1\6\1\151\20\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\26\6"+
    "\1\152\1\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\1\6\1\153\2\6\1\154\23\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\1\6\1\155\1\6\1\156\4\6\1\157\17\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\3\6\1\160\14\6\1\161\7\6\11\0\1\6"+
    "\10\0\2\11\1\0\1\11\6\0\2\11\1\162\1\0"+
    "\1\11\1\0\2\11\1\0\1\11\34\0\2\11\1\0"+
    "\1\11\12\0\2\11\1\0\1\11\6\0\3\11\1\0"+
    "\1\163\1\0\2\11\1\0\1\11\34\0\1\11\1\164"+
    "\1\0\1\11\76\0\1\165\4\0\15\64\1\0\11\64"+
    "\2\0\40\64\1\0\2\64\1\0\1\64\74\0\1\70"+
    "\1\0\4\166\1\167\4\166\1\170\3\166\1\0\12\166"+
    "\1\167\2\166\1\171\3\166\1\172\2\166\1\75\2\166"+
    "\1\173\23\166\1\167\1\166\2\0\1\166\74\0\1\75"+
    "\12\0\1\174\155\0\1\175\5\0\1\6\1\0\1\6"+
    "\10\0\1\176\5\0\1\6\6\0\30\6\11\0\1\6"+
    "\5\0\1\177\75\0\1\200\20\0\1\201\56\0\1\202"+
    "\71\0\27\101\1\0\46\101\15\0\1\103\6\0\1\103"+
    "\47\0\1\103\16\0\1\105\6\0\1\105\47\0\1\105"+
    "\2\0\4\106\15\0\1\106\6\0\30\106\11\0\1\106"+
    "\10\0\2\107\1\0\1\107\2\0\1\203\3\0\3\107"+
    "\1\0\1\107\1\0\2\107\1\0\1\107\34\0\2\107"+
    "\1\0\1\107\20\0\1\203\74\0\1\111\1\204\63\0"+
    "\4\112\15\0\1\112\6\0\30\112\11\0\1\112\4\0"+
    "\4\113\2\0\1\205\6\0\1\206\3\0\1\113\6\0"+
    "\30\113\11\0\1\113\15\0\1\207\64\0\1\210\1\0"+
    "\1\210\16\0\1\210\6\0\30\210\11\0\1\210\24\0"+
    "\1\211\61\0\2\11\1\0\1\11\6\0\2\11\1\212"+
    "\1\0\1\11\1\0\2\11\1\0\1\11\34\0\2\11"+
    "\1\0\1\11\5\0\15\122\1\0\56\122\1\0\1\122"+
    "\5\213\2\123\1\213\1\123\6\213\3\123\1\213\1\123"+
    "\1\213\1\123\1\214\1\213\1\123\34\213\2\123\1\213"+
    "\1\123\5\213\24\0\1\124\25\0\1\125\57\0\1\215"+
    "\42\0\4\6\2\0\1\76\12\0\1\6\6\0\2\6"+
    "\1\216\25\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\4\6\1\217\23\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\12\6"+
    "\1\220\15\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\6\6\1\221\21\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\1\222"+
    "\11\6\1\223\3\6\1\224\11\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\22\6\1\225"+
    "\5\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\3\6\1\226\24\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\10\6\1\227"+
    "\17\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\22\6\1\230\5\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\20\6\1\231"+
    "\7\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\1\232\27\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\12\6\1\233\15\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\1\234\27\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\6\6\1\235\21\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\4\6\1\236\23\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\6\6\1\237\21\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\10\6\1\240\17\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\11\6\1\241\16\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\3\6\1\242\24\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\6\6\1\243\21\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\2\6\1\244\25\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\6\6\1\245\13\6\1\246"+
    "\5\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\1\6\1\247\26\6\11\0\1\6\74\0"+
    "\1\250\6\0\2\251\16\0\1\251\6\0\1\251\2\0"+
    "\1\251\4\0\1\251\4\0\2\251\1\0\1\251\115\0"+
    "\1\252\6\0\1\177\17\0\1\100\16\0\1\100\36\0"+
    "\1\200\74\0\1\113\1\0\1\113\10\0\1\115\5\0"+
    "\1\113\6\0\30\113\11\0\1\113\15\0\1\207\1\253"+
    "\63\0\4\210\11\0\1\206\3\0\1\210\6\0\30\210"+
    "\11\0\1\210\3\0\26\213\1\254\54\213\2\123\1\213"+
    "\1\123\6\213\3\123\1\213\1\123\1\213\1\255\1\214"+
    "\1\213\1\123\34\213\2\123\1\213\1\123\5\213\37\0"+
    "\1\256\37\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\3\6\1\257\24\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\10\6\1\260\17\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\6\6\1\261\21\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\5\6\1\262\22\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\6\6\1\263\21\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\4\6\1\264\23\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\1\6\1\265\26\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\11\6\1\266\16\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\11\6\1\267\16\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\10\6\1\270\17\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\5\6\1\271\22\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\10\6\1\272\17\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\10\6\1\273\17\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\1\6\1\274\26\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\10\6\1\275\17\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\10\6\1\276\17\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\7\6\1\277\20\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\2\6\1\300\6\6\1\301"+
    "\16\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\12\6\1\302\15\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\12\6\1\303"+
    "\15\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\3\6\1\304\24\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\5\6\1\305"+
    "\22\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\16\6\1\306\11\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\22\6\1\307"+
    "\5\6\11\0\1\6\5\0\2\310\16\0\1\310\6\0"+
    "\1\310\2\0\1\310\4\0\1\310\4\0\2\310\1\0"+
    "\1\310\42\0\1\206\57\0\25\213\1\311\1\254\47\213"+
    "\47\0\1\312\27\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\4\6\1\313\23\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\2\6\1\314\25\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\17\6\1\315\10\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\3\6\1\316\24\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\14\6\1\317\13\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\2\6\1\320\25\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\12\6\1\321\15\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\11\6\1\322\16\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\16\6\1\323\11\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\2\6\1\324\25\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\11\6\1\325\16\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\16\6\1\326\11\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\10\6\1\327\17\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\6\6\1\330\21\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\12\6\1\331\15\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\25\6\1\332\2\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\7\6\1\333\20\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\5\6\1\334\22\6"+
    "\11\0\1\6\5\0\2\335\16\0\1\335\6\0\1\335"+
    "\2\0\1\335\4\0\1\335\4\0\2\335\1\0\1\335"+
    "\64\0\1\336\36\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\4\6\1\337\23\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\3\6\1\340\24\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\2\6\1\341\1\6\1\342\23\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\11\6"+
    "\1\343\16\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\20\6\1\344\7\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\6\6"+
    "\1\345\21\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\1\346\27\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\23\6\1\347"+
    "\4\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\6\6\1\350\21\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\16\6\1\351"+
    "\11\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\20\6\1\352\7\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\6\6\1\353"+
    "\21\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\2\6\1\354\25\6\11\0\1\6\4\0"+
    "\4\6\2\0\1\76\12\0\1\6\6\0\5\6\1\355"+
    "\22\6\11\0\1\6\4\0\4\6\2\0\1\76\12\0"+
    "\1\6\6\0\11\6\1\356\16\6\11\0\1\6\5\0"+
    "\2\357\16\0\1\357\6\0\1\357\2\0\1\357\4\0"+
    "\1\357\4\0\2\357\1\0\1\357\25\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\16\6\1\360\11\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\16\6\1\361\11\6\11\0\1\6\4\0\4\6\2\0"+
    "\1\76\12\0\1\6\6\0\10\6\1\362\17\6\11\0"+
    "\1\6\4\0\4\6\2\0\1\76\12\0\1\6\6\0"+
    "\27\6\1\363\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\1\6\1\364\26\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\10\6"+
    "\1\365\17\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\12\6\1\366\15\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\1\0\1\367"+
    "\4\0\30\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\3\6\1\370\24\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\11\6"+
    "\1\371\16\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\23\6\1\372\4\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\6\6"+
    "\1\373\21\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\10\6\1\374\17\6\11\0\1\6"+
    "\4\0\4\6\2\0\1\76\12\0\1\6\6\0\3\6"+
    "\1\375\24\6\11\0\1\6\4\0\4\6\2\0\1\76"+
    "\12\0\1\6\6\0\2\6\1\376\25\6\11\0\1\6"+
    "\27\0\1\367\4\0\1\377\17\0\1\u0100\25\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\5\6\1\u0101\22\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\23\6\1\u0102\4\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\1\0\1\u0103\4\0\30\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\1\0\1\u0104\4\0\30\6\11\0\1\6\4\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\25\6\1\u0105\2\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\21\6\1\u0106\6\6\11\0\1\6\41\0\1\u0107"+
    "\75\0\1\u0108\40\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\11\6\1\u0109\16\6\11\0\1\6\27\0\1\u0103"+
    "\6\0\1\u010a\66\0\1\u0104\6\0\1\u010b\43\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\3\6\1\u010c\24\6"+
    "\11\0\1\6\4\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\3\6\1\u010d\24\6\11\0\1\6\36\0\1\u010e"+
    "\105\0\1\u010f\33\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\6\6\1\u0110\21\6\11\0\1\6\44\0\1\u0111"+
    "\101\0\1\u0112\31\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\6\6\1\u0113\21\6\11\0\1\6\46\0\1\u0114"+
    "\71\0\1\u0115\73\0\1\u0116\75\0\1\u0117\41\0\4\6"+
    "\2\0\1\76\12\0\1\6\6\0\5\6\1\u0118\22\6"+
    "\11\0\1\6\42\0\1\u0119\74\0\1\u011a\73\0\1\u011b"+
    "\102\0\1\u011c\35\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\1\6\1\u011d\26\6\11\0\1\6\45\0\1\u011e"+
    "\72\0\1\u011f\37\0\4\6\2\0\1\76\12\0\1\6"+
    "\6\0\11\6\1\u0120\16\6\11\0\1\6\52\0\1\u0121"+
    "\64\0\1\u0122\76\0\1\u0123\70\0\1\u0124\105\0\1\u0125"+
    "\33\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13330];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\10\1\11\10\1\2\11\10\1\1\11\17\1"+
    "\4\11\2\1\1\11\3\1\2\11\2\1\1\0\2\11"+
    "\4\1\1\11\5\0\1\1\1\11\2\1\3\0\1\1"+
    "\4\0\5\1\2\0\37\1\1\0\5\11\1\1\1\11"+
    "\2\0\2\1\1\0\3\11\1\0\1\11\2\0\1\11"+
    "\1\1\1\0\1\1\1\0\32\1\1\11\1\0\1\11"+
    "\2\0\1\1\1\0\31\1\1\0\1\11\1\0\22\1"+
    "\1\0\1\11\20\1\1\11\7\1\1\0\7\1\2\0"+
    "\2\1\2\0\2\1\2\0\1\1\2\0\2\1\2\0"+
    "\1\1\2\0\1\1\4\0\1\1\1\11\2\0\1\11"+
    "\1\1\2\0\1\1\2\0\1\11\1\0\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[293];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /* user code: */
    public SCLParserOptions options = SCLParserOptions.DEFAULT;
    int stringStart;
    TIntArrayList parenCountStack = new TIntArrayList(2);
    int parenCount = 0;
    TIntArrayList stateStack = new TIntArrayList(2);

    StringBuffer string = new StringBuffer();
    
    private Token sym(int id) {
        return new Token(id, yychar, yychar+yylength(), yytext());
    }
    private Token sym(int id, String text) {
        return new Token(id, yychar, yychar+yylength(), text);
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public SCLLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 190) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) throws RuntimeException {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new RuntimeException(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  throws RuntimeException {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Token nextToken() throws java.io.IOException, SCLSyntaxErrorException, RuntimeException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
            switch (zzLexicalState) {
            case STRING: {
              throw new SCLSyntaxErrorException(Locations.location(stringStart, yychar), "Unclosed string literal.");
            }
            case 294: break;
            case LONG_STRING: {
              throw new SCLSyntaxErrorException(Locations.location(stringStart, yychar), "Unclosed string literal.");
            }
            case 295: break;
            default:
          {     return sym(SCLTerminals.EOF);
 }
        }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { throw new SCLSyntaxErrorException(Locations.location(yychar, yychar+1), "Illegal character '" + yytext() + "'.");
            }
          case 95: break;
          case 2: 
            { return sym(SCLTerminals.ID);
            }
          case 96: break;
          case 3: 
            { return sym(SCLTerminals.INTEGER);
            }
          case 97: break;
          case 4: 
            { return sym(SCLTerminals.SYMBOL, yytext().trim());
            }
          case 98: break;
          case 5: 
            { return sym(SCLTerminals.ATTACHED_HASH, "#");
            }
          case 99: break;
          case 6: 
            { return sym(SCLTerminals.ATTACHED_DOT, ".");
            }
          case 100: break;
          case 7: 
            { return sym(SCLTerminals.AT);
            }
          case 101: break;
          case 8: 
            { ++parenCount; return sym(SCLTerminals.LPAREN);
            }
          case 102: break;
          case 9: 
            { return sym(SCLTerminals.COMMA);
            }
          case 103: break;
          case 10: 
            { --parenCount;
                    if(parenCount == 0 && !parenCountStack.isEmpty()) { 
                       parenCount = parenCountStack.removeAt(parenCountStack.size()-1);
                       string.setLength(0);
                       stringStart=yychar;
                       yybegin(stateStack.removeAt(stateStack.size()-1));
                       return sym(SCLTerminals.CONTINUE_STRING);
                    }
                    else
                       return sym(SCLTerminals.RPAREN);
            }
          case 104: break;
          case 11: 
            { return new Token(SCLTerminals.EOL, yychar, yychar+yylength(), "");
            }
          case 105: break;
          case 12: 
            { return sym(SCLTerminals.LESS, "<");
            }
          case 106: break;
          case 13: 
            { return sym(SCLTerminals.GREATER, ">");
            }
          case 107: break;
          case 14: 
            { return sym(SCLTerminals.MINUS, "-");
            }
          case 108: break;
          case 15: 
            { 
            }
          case 109: break;
          case 16: 
            { throw new SCLSyntaxErrorException(Locations.location(yychar, yychar+1), "Character does not conform to UTF-8 encoding.");
            }
          case 110: break;
          case 17: 
            { return sym(SCLTerminals.LAMBDA);
            }
          case 111: break;
          case 18: 
            { return sym(SCLTerminals.LBRACE);
            }
          case 112: break;
          case 19: 
            { return sym(SCLTerminals.RBRACE);
            }
          case 113: break;
          case 20: 
            { return sym(SCLTerminals.LBRACKET);
            }
          case 114: break;
          case 21: 
            { return sym(SCLTerminals.RBRACKET);
            }
          case 115: break;
          case 22: 
            { return sym(SCLTerminals.EQUALS);
            }
          case 116: break;
          case 23: 
            { return sym(SCLTerminals.COLON);
            }
          case 117: break;
          case 24: 
            { return sym(SCLTerminals.SEMICOLON);
            }
          case 118: break;
          case 25: 
            { return sym(SCLTerminals.BAR);
            }
          case 119: break;
          case 26: 
            { string.setLength(0); stringStart=yychar; yybegin(STRING); return sym(SCLTerminals.BEGIN_STRING);
            }
          case 120: break;
          case 27: 
            { return sym(SCLTerminals.BLANK);
            }
          case 121: break;
          case 28: 
            { throw new SCLSyntaxErrorException(Locations.location(yychar, yychar+1), "Tabulator is not allowed except inside string literals.");
            }
          case 122: break;
          case 29: 
            { string.append( yytext() );
            }
          case 123: break;
          case 30: 
            { throw new SCLSyntaxErrorException(Locations.location(stringStart, yychar), "Unclosed string literal.");
            }
          case 124: break;
          case 31: 
            { yybegin(YYINITIAL); 
                    return new Token(SCLTerminals.END_STRING, stringStart, yychar+1, string.toString());
            }
          case 125: break;
          case 32: 
            { string.append('\n');
            }
          case 126: break;
          case 33: 
            { return sym(SCLTerminals.DOTDOT, ".");
            }
          case 127: break;
          case 34: 
            { return sym(SCLTerminals.SEPARATED_DOT, ".");
            }
          case 128: break;
          case 35: 
            { return sym(SCLTerminals.ANNOTATION_ID);
            }
          case 129: break;
          case 36: 
            { return sym(SCLTerminals.BINDS);
            }
          case 130: break;
          case 37: 
            { return sym(SCLTerminals.ARROW);
            }
          case 131: break;
          case 38: 
            { return sym(SCLTerminals.COMMENT);
            }
          case 132: break;
          case 39: 
            { return sym(SCLTerminals.AS);
            }
          case 133: break;
          case 40: 
            { return sym(SCLTerminals.IF);
            }
          case 134: break;
          case 41: 
            { return sym(SCLTerminals.IN);
            }
          case 135: break;
          case 42: 
            { return sym(options.supportEq ? SCLTerminals.EQ : SCLTerminals.ID);
            }
          case 136: break;
          case 43: 
            { return sym(SCLTerminals.BY);
            }
          case 137: break;
          case 44: 
            { return sym(SCLTerminals.DO);
            }
          case 138: break;
          case 45: 
            { return sym(SCLTerminals.IMPLIES);
            }
          case 139: break;
          case 46: 
            { return sym(SCLTerminals.FOLLOWS);
            }
          case 140: break;
          case 47: 
            { return sym(SCLTerminals.HASTYPE);
            }
          case 141: break;
          case 48: 
            { throw new SCLSyntaxErrorException(Locations.location(stringStart, yychar), "Illegal string escape character.");
            }
          case 142: break;
          case 49: 
            { string.append(yytext().substring(1));
            }
          case 143: break;
          case 50: 
            { parenCountStack.add(parenCount);
                    parenCount = 1;
                    stateStack.add(STRING);
                    yybegin(YYINITIAL); 
                    return new Token(SCLTerminals.SUSPEND_STRING, stringStart, yychar+1, string.toString());
            }
          case 144: break;
          case 51: 
            { string.append('\r');
            }
          case 145: break;
          case 52: 
            { string.append('\t');
            }
          case 146: break;
          case 53: 
            { parenCountStack.add(parenCount);
                    parenCount = 1;
                    stateStack.add(LONG_STRING);
                    yybegin(YYINITIAL); 
                    return new Token(SCLTerminals.SUSPEND_STRING, stringStart, yychar+1, string.toString());
            }
          case 147: break;
          case 54: 
            { return sym(SCLTerminals.FLOAT);
            }
          case 148: break;
          case 55: 
            { return sym(SCLTerminals.CHAR);
            }
          case 149: break;
          case 56: 
            { String text = yytext();
                     return sym(SCLTerminals.ID, text.substring(1, text.length()-1));
            }
          case 150: break;
          case 57: 
            { String text = yytext();
                     return sym(SCLTerminals.SYMBOL, text.substring(1, text.length()-1));
            }
          case 151: break;
          case 58: 
            { return sym(SCLTerminals.QUERY_OP);
            }
          case 152: break;
          case 59: 
            { return sym(SCLTerminals.LET);
            }
          case 153: break;
          case 60: 
            { return sym(SCLTerminals.MDO);
            }
          case 154: break;
          case 61: 
            { string.setLength(0); stringStart=yychar; yybegin(LONG_STRING); return sym(SCLTerminals.BEGIN_STRING);
            }
          case 155: break;
          case 62: 
            { yybegin(YYINITIAL); 
                      return new Token(SCLTerminals.END_STRING, stringStart, yychar+3, string.toString());
            }
          case 156: break;
          case 63: 
            { return sym(SCLTerminals.RULE);
            }
          case 157: break;
          case 64: 
            { return sym(SCLTerminals.THEN);
            }
          case 158: break;
          case 65: 
            { return sym(SCLTerminals.TYPE);
            }
          case 159: break;
          case 66: 
            { return sym(SCLTerminals.ELSE);
            }
          case 160: break;
          case 67: 
            { return sym(SCLTerminals.WITH);
            }
          case 161: break;
          case 68: 
            { return sym(SCLTerminals.WHEN);
            }
          case 162: break;
          case 69: 
            { return sym(SCLTerminals.DATA);
            }
          case 163: break;
          case 70: 
            { return sym(SCLTerminals.INFIX);
            }
          case 164: break;
          case 71: 
            { return sym(SCLTerminals.WHERE);
            }
          case 165: break;
          case 72: 
            { return sym(SCLTerminals.CLASS);
            }
          case 166: break;
          case 73: 
            { return sym(SCLTerminals.MATCH);
            }
          case 167: break;
          case 74: 
            { return sym(SCLTerminals.LAMBDA_MATCH);
            }
          case 168: break;
          case 75: 
            { return sym(SCLTerminals.FORALL);
            }
          case 169: break;
          case 76: 
            { return sym(SCLTerminals.INFIXR);
            }
          case 170: break;
          case 77: 
            { return sym(SCLTerminals.INFIXL);
            }
          case 171: break;
          case 78: 
            { return sym(SCLTerminals.IMPORT);
            }
          case 172: break;
          case 79: 
            { return sym(SCLTerminals.HIDING);
            }
          case 173: break;
          case 80: 
            { return sym(SCLTerminals.EFFECT);
            }
          case 174: break;
          case 81: 
            { return sym(SCLTerminals.SELECT);
            }
          case 175: break;
          case 82: 
            { string.append((char)Integer.parseInt(yytext().substring(2), 16));
            }
          case 176: break;
          case 83: 
            { return sym(SCLTerminals.INCLUDE);
            }
          case 177: break;
          case 84: 
            { return sym(SCLTerminals.ENFORCE);
            }
          case 178: break;
          case 85: 
            { return sym(SCLTerminals.EXTENDS);
            }
          case 179: break;
          case 86: 
            { return sym(SCLTerminals.INSTANCE);
            }
          case 180: break;
          case 87: 
            { return sym(SCLTerminals.DERIVING);
            }
          case 181: break;
          case 88: 
            { return sym(SCLTerminals.IMPORTJAVA);
            }
          case 182: break;
          case 89: 
            { return sym(SCLTerminals.CONSTRAINT);
            }
          case 183: break;
          case 90: 
            { return sym(SCLTerminals.SELECT_FIRST);
            }
          case 184: break;
          case 91: 
            { return sym(SCLTerminals.ABSTRACT_RULE);
            }
          case 185: break;
          case 92: 
            { return sym(SCLTerminals.TRANSFORMATION);
            }
          case 186: break;
          case 93: 
            { return sym(SCLTerminals.SELECT_DISTINCT);
            }
          case 187: break;
          case 94: 
            { return sym(SCLTerminals.MAPPING_RELATION);
            }
          case 188: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
