package org.simantics.scl.compiler.internal.header;

import java.util.List;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.annotations.AnnotationUtils;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.parsing.declarations.DModuleHeader;

public class ModuleHeader {
    public String classLoader;
    public long classLoaderLocation;
    public String defaultLocalName;
    public boolean fields;
    public List<EVar> export;
    
    private void read(ErrorLog errorLog, DModuleHeader header) {
        for(FieldAssignment assignment : header.fields)
            switch(assignment.name) {
            case "bundle":
                if(assignment.value == null)
                    errorLog.log(assignment.location, "Property classLoader needs to be given a string value.");
                else {
                    classLoader = AnnotationUtils.extractString(assignment.value);
                    if(classLoader == null)
                        errorLog.log(assignment.value.location, "Expected bundle name here.");
                    else 
                        classLoaderLocation = assignment.location;
                }
                break;
            case "export":
                if(assignment.value == null)
                    errorLog.log(assignment.location, "Property export needs to be given a string list value.");
                else {
                    export = AnnotationUtils.extractIdentifierList(assignment.value);
                    if(export == null)
                        errorLog.log(assignment.value.location, "Expected a list of exported items.");
                }
                break;
            case "defaultLocalName":
            	if(assignment.value == null)
                    errorLog.log(assignment.location, "Property defaultLocalName needs to be given a string value.");
            	else {
            		defaultLocalName = AnnotationUtils.extractString(assignment.value);
            		if(defaultLocalName == null)
            			errorLog.log(assignment.value.location, "Expected string here.");
            	}
            	break;
            case "fields":
                if(assignment.value != null)
                    errorLog.log(assignment.location, "No value expected for property fields.");
                this.fields = true;
                break;
            default:
                errorLog.logWarning(assignment.location, "Unknown module header field was skipped.");
            }
    }
    
    public static ModuleHeader process(ErrorLog errorLog, DModuleHeader header) {
        if(header == null)
            return null;
        ModuleHeader result = new ModuleHeader();
        result.read(errorLog, header);
        return result;
    }
}
