package org.simantics.scl.compiler.internal.elaboration.constraints2;

import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;

public class ConstraintSolver {
    final Environment environment;
    private final THashMap<TCon, ConstraintStore> constraintStores = 
            new THashMap<TCon, ConstraintStore>();
    
    public ConstraintSolver(Environment environment) {
        this.environment = environment;
    }

    private ConstraintStore getConstraintStore(TCon typeClass) {
        ConstraintStore store = constraintStores.get(typeClass);
        if(store == null) {
            store = new ConstraintStore(this, typeClass);
            constraintStores.put(typeClass, store);
        }
        return store;
    }
    
    public ConstraintHandle addDemand(TPred pred, long location) {
        return getConstraintStore(pred.typeClass).addConstraint(pred, location);
    }
    
    public void print() {
        final TypeUnparsingContext tuc = new TypeUnparsingContext();
        constraintStores.forEachEntry(new TObjectObjectProcedure<TCon, ConstraintStore>() {
            @Override
            public boolean execute(TCon pred, ConstraintStore store) {
                store.print(tuc);
                return true;
            }
        });
    }
}
