package org.simantics.scl.compiler.internal.elaboration.constraints;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.ClassConstant;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaConstructor;
import org.simantics.scl.compiler.constants.JavaStaticField;
import org.simantics.scl.compiler.constants.JavaStaticMethod;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.MultiApply;

import gnu.trove.map.hash.THashMap;

public class ReduceSerializable {
    
    private static final TVar A = Types.var(Kinds.STAR);
    private static final TVar B = Types.var(Kinds.STAR);
    
    private static final Type SERIALIZABLE_BOOLEAN = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN);
    private static final Type SERIALIZABLE_BYTE = Types.pred(Types.SERIALIZABLE, Types.BYTE);
    private static final Type SERIALIZABLE_INTEGER = Types.pred(Types.SERIALIZABLE, Types.INTEGER);
    private static final Type SERIALIZABLE_LONG = Types.pred(Types.SERIALIZABLE, Types.LONG);
    private static final Type SERIALIZABLE_FLOAT = Types.pred(Types.SERIALIZABLE, Types.FLOAT);
    private static final Type SERIALIZABLE_DOUBLE = Types.pred(Types.SERIALIZABLE, Types.DOUBLE);
    private static final Type SERIALIZABLE_STRING = Types.pred(Types.SERIALIZABLE, Types.STRING);
    
    private static final Type SERIALIZABLE_BOOLEAN_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BOOLEAN_ARRAY);
    private static final Type SERIALIZABLE_BYTE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.BYTE_ARRAY);
    private static final Type SERIALIZABLE_INTEGER_ARRAY = Types.pred(Types.SERIALIZABLE, Types.INTEGER_ARRAY);
    private static final Type SERIALIZABLE_LONG_ARRAY = Types.pred(Types.SERIALIZABLE, Types.LONG_ARRAY);
    private static final Type SERIALIZABLE_FLOAT_ARRAY = Types.pred(Types.SERIALIZABLE, Types.FLOAT_ARRAY);
    private static final Type SERIALIZABLE_DOUBLE_ARRAY = Types.pred(Types.SERIALIZABLE, Types.DOUBLE_ARRAY);
    
    private static final Type SERIALIZABLE_BOOLEAN_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.BOOLEAN));
    private static final Type SERIALIZABLE_BYTE_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.BYTE));
    private static final Type SERIALIZABLE_INTEGER_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.INTEGER));
    private static final Type SERIALIZABLE_LONG_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.LONG));
    private static final Type SERIALIZABLE_FLOAT_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.FLOAT));
    private static final Type SERIALIZABLE_DOUBLE_VECTOR = Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, Types.DOUBLE));
    
    private static final Type SERIALIZABLE_TUPLE0 = Types.pred(Types.SERIALIZABLE, Types.tuple());
    private static final Type SERIALIZABLE_VARIANT = Types.pred(Types.SERIALIZABLE, Types.VARIANT);
    
    private static final TCon MLIST = Types.con("MList", "T");
    private static final TCon MAP = Types.con("Map", "T");
    private static final TCon MMAP = Types.con("MMap", "T");
    
    private static Constant GET_BINDING =
            new JavaStaticMethod("org/simantics/databoard/Bindings", "getBinding", Types.NO_EFFECTS,
                    Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.VEC_COMP, A));

    private static final THashMap<TCon,Constant> BINDING_CONSTANTS0 = new THashMap<TCon,Constant>();
    static {
        BINDING_CONSTANTS0.put(Types.DOUBLE,        new JavaStaticField("org/simantics/databoard/Bindings", "DOUBLE",        Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/DoubleBinding"),  SERIALIZABLE_DOUBLE, -1));
        BINDING_CONSTANTS0.put(Types.STRING,        new JavaStaticField("org/simantics/databoard/Bindings", "STRING",        Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/StringBinding"),  SERIALIZABLE_STRING, -1));
        BINDING_CONSTANTS0.put(Types.INTEGER,       new JavaStaticField("org/simantics/databoard/Bindings", "INTEGER",       Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/IntegerBinding"), SERIALIZABLE_INTEGER, -1));
        BINDING_CONSTANTS0.put(Types.BOOLEAN,       new JavaStaticField("org/simantics/databoard/Bindings", "BOOLEAN",       Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/BooleanBinding"), SERIALIZABLE_BOOLEAN, -1));
        BINDING_CONSTANTS0.put(Types.BYTE,          new JavaStaticField("org/simantics/databoard/Bindings", "BYTE",          Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ByteBinding"),    SERIALIZABLE_BYTE, -1));
        BINDING_CONSTANTS0.put(Types.FLOAT,         new JavaStaticField("org/simantics/databoard/Bindings", "FLOAT",         Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/FloatBinding"),   SERIALIZABLE_FLOAT, -1));
        BINDING_CONSTANTS0.put(Types.LONG,          new JavaStaticField("org/simantics/databoard/Bindings", "LONG",          Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/LongBinding"),    SERIALIZABLE_LONG, -1));
        BINDING_CONSTANTS0.put(Types.UNIT,          new JavaStaticField("org/simantics/databoard/Bindings", "VOID",          Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/Binding"),        SERIALIZABLE_TUPLE0, -1));
        BINDING_CONSTANTS0.put(Types.VARIANT,       new JavaStaticField("org/simantics/databoard/Bindings", "VARIANT",       Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/VariantBinding"), SERIALIZABLE_VARIANT, -1));
        BINDING_CONSTANTS0.put(Types.DOUBLE_ARRAY,  new JavaStaticField("org/simantics/databoard/Bindings", "DOUBLE_ARRAY",  Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_DOUBLE_ARRAY, -1));
        BINDING_CONSTANTS0.put(Types.INTEGER_ARRAY, new JavaStaticField("org/simantics/databoard/Bindings", "INTEGER_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_INTEGER_ARRAY, -1));
        BINDING_CONSTANTS0.put(Types.BOOLEAN_ARRAY, new JavaStaticField("org/simantics/databoard/Bindings", "BOOLEAN_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_BOOLEAN_ARRAY, -1));
        BINDING_CONSTANTS0.put(Types.BYTE_ARRAY,    new JavaStaticField("org/simantics/databoard/Bindings", "BYTE_ARRAY",    Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_BYTE_ARRAY, -1));
        BINDING_CONSTANTS0.put(Types.FLOAT_ARRAY,   new JavaStaticField("org/simantics/databoard/Bindings", "FLOAT_ARRAY",   Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_FLOAT_ARRAY, -1));
        BINDING_CONSTANTS0.put(Types.LONG_ARRAY,    new JavaStaticField("org/simantics/databoard/Bindings", "LONG_ARRAY",    Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"),   SERIALIZABLE_LONG_ARRAY, -1));
    }
    
    private static final THashMap<TCon,Constant> BINDING_CONSTANTS1 = new THashMap<TCon,Constant>();
    static {
        BINDING_CONSTANTS1.put(Types.LIST,   new JavaConstructor("org/simantics/databoard/binding/impl/ArrayListBinding",       Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.list(A)),               Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put(Types.MAYBE,  new JavaConstructor("org/simantics/databoard/binding/impl/OptionalBindingDefault", Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.apply(Types.MAYBE, A)), Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put(Types.VECTOR, new JavaStaticMethod("org/simantics/databoard/Bindings", "getArrayBinding",        Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.pred(Types.VECTOR, A)), Types.pred(Types.SERIALIZABLE, A)));
        BINDING_CONSTANTS1.put(MLIST,        new JavaConstructor("org/simantics/databoard/binding/impl/ArrayListBinding",       Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.apply(MLIST, A)),       Types.pred(Types.SERIALIZABLE, A)));
    }
    
    private static final THashMap<TCon,Constant> VECTOR_BINDING_CONSTANTS = new THashMap<TCon,Constant>();
    static {
        VECTOR_BINDING_CONSTANTS.put(Types.DOUBLE,  new JavaStaticField("org/simantics/databoard/Bindings", "DOUBLE_ARRAY",  Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_DOUBLE_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put(Types.INTEGER, new JavaStaticField("org/simantics/databoard/Bindings", "INTEGER_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_INTEGER_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put(Types.BOOLEAN, new JavaStaticField("org/simantics/databoard/Bindings", "BOOLEAN_ARRAY", Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_BOOLEAN_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put(Types.BYTE,    new JavaStaticField("org/simantics/databoard/Bindings", "BYTE_ARRAY",    Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_BYTE_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put(Types.FLOAT,   new JavaStaticField("org/simantics/databoard/Bindings", "FLOAT_ARRAY",   Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_FLOAT_VECTOR, -1));
        VECTOR_BINDING_CONSTANTS.put(Types.LONG,    new JavaStaticField("org/simantics/databoard/Bindings", "LONG_ARRAY",    Types.NO_EFFECTS, TypeDesc.forClass("org/simantics/databoard/binding/ArrayBinding"), SERIALIZABLE_LONG_VECTOR, -1));
    }
    
    private static final THashMap<TCon,Constant> BINDING_CONSTANTS2 = new THashMap<TCon,Constant>();
    static {
        BINDING_CONSTANTS2.put(MAP, new JavaConstructor("org/simantics/databoard/binding/impl/DefaultMapBinding", Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.apply(MAP, A, B)), Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.SERIALIZABLE, B)));
        BINDING_CONSTANTS2.put(MMAP, new JavaConstructor("org/simantics/databoard/binding/impl/DefaultMapBinding", Types.NO_EFFECTS, Types.pred(Types.SERIALIZABLE, Types.apply(MMAP, A, B)), Types.pred(Types.SERIALIZABLE, A), Types.pred(Types.SERIALIZABLE, B)));
    }
        
    public static Reduction reduceSerializable(Type parameter) {
        MultiApply apply = Types.matchApply(parameter);
        if(!(apply.constructor instanceof TCon))
            return null;
        
        switch(apply.parameters.length) {
        case 0: {
            Constant constant = BINDING_CONSTANTS0.get(apply.constructor);
            if(constant != null)
                return new Reduction(new ELiteral(constant), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
        } break;
        case 1: {
            Type parameter0 = apply.parameters[0];
            if(apply.constructor == Types.VECTOR) {
                Constant vecConstant = VECTOR_BINDING_CONSTANTS.get(parameter0);
                if(vecConstant != null)
                    return new Reduction(new ELiteral(vecConstant), Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
            }
            Constant constant = BINDING_CONSTANTS1.get(apply.constructor);
            if(constant != null)
                return new Reduction(new EApplyType(new ELiteral(constant), parameter0), Type.EMPTY_ARRAY, new TPred[] { Types.pred(Types.SERIALIZABLE, parameter0) });
        } break;
        case 2: {
            Constant constant = BINDING_CONSTANTS2.get(apply.constructor);
            if(constant != null)
                return new Reduction(Expressions.applyTypes(new ELiteral(constant), apply.parameters),
                        Type.EMPTY_ARRAY,
                        new TPred[] { Types.pred(Types.SERIALIZABLE, apply.parameters[0]), Types.pred(Types.SERIALIZABLE, apply.parameters[1]) });
        } break;
        }
      
        // Default to a binding based on the class of the type.
        // This can be applied only if the type is ground type (i.e. does not contain type variables),
        // because otherwise the Serializable instance could be provided as a parameter to the function
        if(parameter.isGround()) {
            Expression bindingGenerator = new EApplyType(new ELiteral(GET_BINDING), parameter);
            Expression bindingExpression = new EApply(bindingGenerator, new ELiteral(new ClassConstant(Types.pred(Types.VEC_COMP, parameter), parameter)));
            return new Reduction(bindingExpression, Type.EMPTY_ARRAY, TPred.EMPTY_ARRAY);
        }
        
        return null;
    }
}
