package org.simantics.scl.compiler.internal.codegen.chr;

import java.util.ArrayList;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Opcodes;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;

public class CHRCodeGenerator {

    public static final TypeDesc FACT_ID_TYPE = TypeDesc.INT;
    private static final String FactActivationQueue_name = "org/simantics/scl/runtime/chr/FactActivationQueue";
    private static final TypeDesc FactActivationQueue = TypeDesc.forClass(FactActivationQueue_name);
    private static final String QUEUE = "queue";

    public static void generateStore(ModuleBuilder moduleBuilder, CHRRuleset ruleset) {
        ClassBuilder storeClassBuilder = new ClassBuilder(moduleBuilder, Opcodes.ACC_PUBLIC, ruleset.storeClassName, "java/lang/Object");
        if(ruleset.parameters == null)
            ruleset.parameters = new BoundVar[0];
        ruleset.parameterTypeDescs = moduleBuilder.getJavaTypeTranslator().getTypeDescs(ruleset.parameters); 

        ArrayList<StoreInitialization> hashIndexInitializations = new ArrayList<>();
        for(CHRConstraint constraint : ruleset.constraints)
            generateFact(storeClassBuilder, constraint, hashIndexInitializations);

        // Fields
        for(int i=0;i<ruleset.parameterTypeDescs.length;++i) {
            TypeDesc typeDesc = ruleset.parameterTypeDescs[i];
            if(typeDesc.equals(TypeDesc.VOID))
                continue;
            storeClassBuilder.addField(Opcodes.ACC_PUBLIC | Opcodes.ACC_FINAL, "p" + i, typeDesc);
        }
        storeClassBuilder.addField(Opcodes.ACC_PUBLIC, "currentId", FACT_ID_TYPE);
        for(StoreInitialization ini : hashIndexInitializations)
            storeClassBuilder.addField(ini.access, ini.fieldName, ini.fieldType);
        storeClassBuilder.addField(Opcodes.ACC_PUBLIC | Opcodes.ACC_FINAL, QUEUE, FactActivationQueue);

        // Constructors

        {
            MethodBuilderBase mb = storeClassBuilder.addConstructor(Opcodes.ACC_PUBLIC, ruleset.parameterTypeDescs);
            mb.loadThis();
            mb.invokeConstructor(storeClassBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
            for(int i=0;i<ruleset.parameterTypeDescs.length;++i) {
                TypeDesc typeDesc = ruleset.parameterTypeDescs[i];
                if(typeDesc.equals(TypeDesc.VOID))
                    continue;
                mb.loadThis();
                mb.loadLocal(mb.getParameter(i));
                mb.storeField(ruleset.storeClassName, "p" + i, ruleset.parameterTypeDescs[i]);
            }
            mb.loadThis();
            mb.loadConstant(1);
            mb.storeField(storeClassBuilder.getClassName(), "currentId", TypeDesc.INT);
            for(StoreInitialization ini : hashIndexInitializations) {
                mb.loadThis();
                mb.newObject(ini.className);
                mb.dup();
                mb.invokeConstructor(ini.className, Constants.EMPTY_TYPEDESC_ARRAY);
                mb.storeField(ruleset.storeClassName, ini.fieldName, ini.fieldType);
            }
            {
                mb.loadThis();
                mb.newObject(FactActivationQueue_name);
                mb.dup();
                mb.loadConstant(ruleset.priorityCount);
                mb.invokeConstructor(FactActivationQueue_name, new TypeDesc[] {TypeDesc.INT});
                mb.storeField(ruleset.storeClassName, QUEUE, FactActivationQueue);
            }
            mb.returnVoid();
            mb.finish();
        }

        // Activate

        {
            MethodBuilderBase mb = storeClassBuilder.addMethodBase(Opcodes.ACC_PUBLIC, "activate", TypeDesc.VOID, new TypeDesc[] {TypeDesc.INT});
            mb.loadThis();
            mb.loadField(ruleset.storeClassName, QUEUE, FactActivationQueue);
            mb.loadThis();
            mb.loadLocal(mb.getParameter(0));
            mb.invokeVirtual(FactActivationQueue_name, "activate", TypeDesc.VOID, new TypeDesc[] {TypeDesc.OBJECT, TypeDesc.INT});
            mb.returnVoid();
            mb.finish();
        }

        moduleBuilder.addClass(storeClassBuilder);
    }

    private static void generateFact(ClassBuilder storeClassBuilder, CHRConstraint constraint, ArrayList<StoreInitialization> hashIndexInitializations) {
        CHRFactCodeGenerator generator = new CHRFactCodeGenerator(storeClassBuilder, constraint);
        generator.generate(hashIndexInitializations);
    }
}
