package org.simantics.scl.compiler.errors;

public class Locations {

    public static final long NO_LOCATION = 0x7fffffff80000000L;
    
    public static long location(int begin, int end) {
        return (((long)begin) << 32) | (((long)end) );
    }
    
    public static int beginOf(long location) {
        return (int)(location >>> 32);
    }
    
    public static int endOf(long location) {
        return (int)location;
    }
    
    public static int length(long location) {
        return endOf(location) - beginOf(location);
    }

    
    public static long combine(long a, long b) {
        return location(Math.min(beginOf(a), beginOf(b)), Math.max(endOf(a), endOf(b)));
    }
    
    public static int compare(long a, long b) {
        if(a < b) 
            return -1;
        if(a > b) 
            return 1;
        return 0;
    }

    public static String annotatate(String annotationBegin, String annotationEnd, String formula, long location) {
        if(location == NO_LOCATION)
            return annotationBegin + formula + annotationEnd;
        int begin = beginOf(location);
        int end = endOf(location);
        return formula.substring(0, begin) + annotationBegin + formula.substring(begin, end) + annotationEnd + formula.substring(end);
    }
}
