package org.simantics.scl.compiler.environment;

import java.util.function.Consumer;

import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.types.TCon;

import gnu.trove.procedure.TObjectProcedure;

public enum EmptyNamespace implements Namespace {
    INSTANCE;

    @Override
    public Namespace getNamespace(String name) {
        return null;
    }

    @Override
    public SCLValue getValue(String name) throws AmbiguousNameException {
        return null;
    }

    @Override
    public SCLRelation getRelation(String name) throws AmbiguousNameException {
        return null;
    }

    @Override
    public SCLEntityType getEntityType(String name)
            throws AmbiguousNameException {
        return null;
    }
    
    @Override
    public TypeConstructor getTypeDescriptor(String name) throws AmbiguousNameException {
        return null;
    }

    @Override
    public EffectConstructor getEffectConstructor(String name)
            throws AmbiguousNameException {
        return null;
    }

    @Override
    public TypeClass getTypeClass(String name) throws AmbiguousNameException {
        return null;
    }

    @Override
    public MappingRelation getMappingRelation(String name)
            throws AmbiguousNameException {
        return null;
    }

    @Override
    public TransformationRule getRule(String name) throws AmbiguousNameException {
        return null;
    }

    @Override
    public void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc) {
    }

    @Override
    public void findTypesForPrefix(String prefix, NamespaceFilter filter, Consumer<TCon> consumer) {
    }
}
