package org.simantics.scl.compiler.elaboration.query.pre;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

/**
 * Query classes that may exist before resolving
 */
public abstract class PreQuery extends Query {

    public ArrayList<Variable> extraVariables = new ArrayList<Variable>(2);
    public ArrayList<Query> sideQueries = new ArrayList<Query>(2);
        
    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support collectFreeVariables.");
    }
    
    @Override
    public void checkType(TypingContext context) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support checkType.");
    }
    
    @Override
    public void collectConstraints(ConstraintCollectionContext context) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support collectConstraints.");
    }
    
    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support collectRefs.");
    }
    
    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support collectVars.");
    }
    
    @Override
    public Query replace(ReplaceContext replaceContext) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support replace.");
    }
    
    @Override
    final public void accept(QueryVisitor visitor) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support accept.");
    }
    
    protected Query withSideQueries(Query query) {
        if(!sideQueries.isEmpty()) {
            sideQueries.add(query);
            query = new QConjunction(sideQueries.toArray(new Query[sideQueries.size()]));
        }
        if(!extraVariables.isEmpty())
            query = new QExists(extraVariables.toArray(new Variable[extraVariables.size()]), query);
        return query;
    }
    
    @Override
    public void forVariables(VariableProcedure procedure) {
        throw new InternalCompilerError(location, getClass().getSimpleName() + " does not support forVariables.");
    }
}
