package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class QIf extends Query {
    public Expression condition;
    public Query thenQuery;
    public Query elseQuery;
    
    public QIf(Expression condition, Query thenQuery, Query elseQuery) {
        this.condition = condition;
        this.thenQuery = thenQuery;
        this.elseQuery = elseQuery;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        condition.collectFreeVariables(vars);
        thenQuery.collectFreeVariables(vars);
        elseQuery.collectFreeVariables(vars);
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        condition.collectRefs(allRefs, refs);
        thenQuery.collectRefs(allRefs, refs);
        elseQuery.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        condition.collectVars(allVars, vars);
        thenQuery.collectVars(allVars, vars);
        elseQuery.collectVars(allVars, vars);
    }

    @Override
    public void checkType(TypingContext context) {
        condition.checkType(context, Types.BOOLEAN);
        thenQuery.checkType(context);
        elseQuery.checkType(context);
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public Query replace(ReplaceContext context) {
        return new QIf(
                condition.replace(context),
                thenQuery.replace(context),
                elseQuery.replace(context));
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            this.location = loc;
            condition.setLocationDeep(loc);
            elseQuery.setLocationDeep(loc);
            thenQuery.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        condition.forVariables(procedure);
        elseQuery.forVariables(procedure);
        thenQuery.forVariables(procedure);
    }
    
    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
    
}
