package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class ListGuard extends ListQualifier {
    public Expression condition;

    public ListGuard(Expression condition) {
        this.condition = condition;
    }

    @Override
    public void checkType(TypingContext context) {
        condition.checkType(context, Types.BOOLEAN);
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
        condition.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        condition.collectVars(allVars, vars);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        condition.collectFreeVariables(vars);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        return new CompiledQualifier(
                context.guardList(condition.copy()), 
                context.tuple());
    }

    @Override
    public void resolve(TranslationContext context) {
        condition = condition.resolve(context);        
    }

    @Override
    public void decorate(ExpressionDecorator decorator) {
        condition = condition.decorate(decorator);
    }
    
    @Override
    public void collectEffects(THashSet<Type> effects) {
        condition.collectEffects(effects);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            condition.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public void forVariables(VariableProcedure procedure) {
        condition.forVariables(procedure);
    }
    
    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}
