package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;

public class LetStatement extends Statement {
    public Expression pattern;
    public Expression value;
    
    public LetStatement(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, boolean monadic, Expression in) {
        if(pattern instanceof EVariable)
            return new ESimpleLet(((EVariable)pattern).getVariable(), value, in);
        else
            //return new EPreLet(Arrays.asList(this), in);
            return new EMatch(location, new Expression[] {value}, new Case[] {new Case(pattern, in)});
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            pattern.setLocationDeep(loc);
            value.setLocationDeep(loc);
        }
    }
    
    @Override
    public void resolvePattern(TranslationContext context) {
        pattern = pattern.resolveAsPattern(context);
    }
    
    @Override
    public boolean mayBeRecursive() {
        return pattern.isFunctionDefinitionLhs();
    }
    
    @Override
    public Statement replace(ReplaceContext context) {
        return new LetStatement(pattern.replaceInPattern(context), value.replace(context));
    }
    
    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        if(pattern.isFunctionPattern())
            return StatementGroup.LetFunction;
        else
            return null;
    }
}