package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.errors.Locations;

public class CHRStatement extends Statement {

    public ListQualifier[] head;
    public ListQualifier[] body;

    public CHRStatement(ListQualifier[] head, ListQualifier[] body) {
        this.head = head;
        this.body = body;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, boolean monadic, Expression in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(ListQualifier lq : head)
                lq.setLocationDeep(loc);
            for(ListQualifier lq : body)
                lq.setLocationDeep(loc);
        }
    }

    @Override
    public void resolvePattern(TranslationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mayBeRecursive() {
        return true;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public StatementGroup getStatementGroup() {
        return StatementGroup.CHR;
    }

}
