package org.simantics.scl.compiler.elaboration.expressions.accessor;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.parsing.Symbol;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class FieldAccessor extends Symbol {
    public char accessSeparator;
    
    public FieldAccessor(char accessSeparator) {
        this.accessSeparator = accessSeparator;
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
    }

    public void collectFreeVariables(THashSet<Variable> vars) {
    }

    public void simplify(SimplificationContext context) {
    }

    public void resolve(TranslationContext context) {
    }

    public void decorate(ExpressionDecorator decorator) {
    }

    public void checkType(TypingContext context) {        
    }

    public abstract Expression asExpression();

    public boolean isVariableId() {
        return false;
    }

    public abstract void setLocationDeep(long loc);

    public abstract void accept(FieldAccessorVisitor visitor);

    public abstract void forVariables(VariableProcedure procedure);
}
