package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.equation.EqBasic;
import org.simantics.scl.compiler.elaboration.equation.EqGuard;
import org.simantics.scl.compiler.elaboration.equation.Equation;
import org.simantics.scl.compiler.elaboration.equation.EquationVisitor;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset.DatalogRule;
import org.simantics.scl.compiler.elaboration.expressions.accessor.ExpressionAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.FieldAccessorVisitor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.IdAccessor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.StringAccessor;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementVisitor;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGuard;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierVisitor;
import org.simantics.scl.compiler.elaboration.expressions.list.ListSeq;
import org.simantics.scl.compiler.elaboration.expressions.list.ListThen;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.query.QAlternative;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.QIf;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.QNegation;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;


public class StandardExpressionVisitor implements 
ExpressionVisitor, QueryVisitor, FieldAccessorVisitor, ListQualifierVisitor,
EquationVisitor, StatementVisitor {

    @Override
    public void visit(EApply expression) {
        expression.function.accept(this);
        for(Expression parameter : expression.parameters)
            parameter.accept(this);
    }

    @Override
    public void visit(EApplyType expression) {
        expression.expression.accept(this);
    }

    @Override
    public void visit(EAsPattern expression) {
        expression.pattern.accept(this);
    }
    
    @Override
    public void visit(EBind expression) {
        expression.pattern.accept(this);
        expression.value.accept(this);
        expression.in.accept(this);
    }

    @Override
    public void visit(EConstant expression) {
    }

    @Override
    public void visit(EEnforce expression) {
        expression.query.accept(this);
    }

    @Override
    public void visit(EError expression) {
    }

    @Override
    public void visit(EExternalConstant expression) {
    }

    @Override
    public void visit(EFieldAccess expression) {
        expression.parent.accept(this);
        expression.accessor.accept(this);
    }

    @Override
    public void visit(EGetConstraint expression) {
        if(expression.evidence != null)
            expression.evidence.accept(this);
    }

    @Override
    public void visit(EIf expression) {
        expression.condition.accept(this);
        expression.then_.accept(this);
        if(expression.else_ != null)
            expression.else_.accept(this);
    }

    @Override
    public void visit(EIntegerLiteral expression) {
        if(expression.constraint != null)
            expression.constraint.accept(this);
    }

    @Override
    public void visit(ELambda expression) {
        for(Case case_ : expression.cases)
            visit(case_);
    }
    
    @Override
    public void visit(EViewPattern expression) {
        expression.expression.accept(this);
        expression.pattern.accept(this);
    }

    public void visit(Case case_) {
        for(Expression pattern : case_.patterns)
            pattern.accept(this);
        case_.value.accept(this);
    }

    @Override
    public void visit(ELambdaType expression) {
        expression.value.accept(this);
    }

    @Override
    public void visit(ELet expression) {
        for(Assignment assignment : expression.assignments)
            visit(assignment);
    }

    public void visit(Assignment assignment) {
        assignment.pattern.accept(this);
        assignment.value.accept(this);
    }

    @Override
    public void visit(EListComprehension expression) {
        expression.head.accept(this);
        expression.qualifier.accept(this);
    }

    @Override
    public void visit(EListLiteral expression) {
        for(Expression component : expression.components)
            component.accept(this);
    }

    @Override
    public void visit(ELiteral expression) {
    }

    @Override
    public void visit(EMatch expression) {
        for(Expression s : expression.scrutinee)
            s.accept(this);
        for(Case case_ : expression.cases)
            visit(case_);
    }

    @Override
    public void visit(EPlaceholder expression) {
        expression.expression.accept(this);
    }

    @Override
    public void visit(ERealLiteral expression) {
        if(expression.constraint != null)
            expression.constraint.accept(this);
    }

    @Override
    public void visit(ERuleset expression) {
        for(DatalogRule rule : expression.rules)
            visit(rule);
        expression.in.accept(this);
    }

    public void visit(DatalogRule rule) {
        for(Expression parameter : rule.headParameters)
            parameter.accept(this);
        rule.body.accept(this);
    }

    @Override
    public void visit(ESelect expression) {
        expression.query.accept(this);
        expression.expression.accept(this);
    }

    @Override
    public void visit(ESimpleLambda expression) {
        expression.value.accept(this);
    }

    @Override
    public void visit(ESimpleLet expression) {
        expression.value.accept(this);
        expression.in.accept(this);
    }

    @Override
    public void visit(ETransformation expression) {
        expression.seed.accept(this);
    }
    
    @Override
    public void visit(ETypeAnnotation expression) {
        expression.value.accept(this);
    }

    @Override
    public void visit(EVar expression) {
    }

    @Override
    public void visit(EVariable expression) {
    }

    @Override
    public void visit(EWhen expression) {
        expression.query.accept(this);
        expression.action.accept(this);
    }

    @Override
    public void visit(GuardedExpressionGroup expression) {
        for(GuardedExpression gexp : expression.expressions) {
            for(Expression guard : gexp.guards)
                guard.accept(this);
            gexp.value.accept(this);
        }
    }

    @Override
    public void visit(QAlternative query) {
        for(Query q : query.queries)
            q.accept(this);
    }

    @Override
    public void visit(QAtom query) {
        for(Expression parameter : query.parameters)
            parameter.accept(this);
    }
    
    @Override
    public void visit(QMapping query) {
        for(Expression parameter : query.parameters)
            parameter.accept(this);
    }

    @Override
    public void visit(QConjunction query) {
        for(Query q : query.queries)
            q.accept(this);
    }

    @Override
    public void visit(QDisjunction query) {
        for(Query q : query.queries)
            q.accept(this);
    }

    @Override
    public void visit(QExists query) {
        query.query.accept(this);
    }

    @Override
    public void visit(QNegation query) {
        query.query.accept(this);
    }

    @Override
    public void visit(ExpressionAccessor accessor) {
        accessor.fieldName.accept(this);
    }

    @Override
    public void visit(IdAccessor accessor) {
    }

    @Override
    public void visit(StringAccessor accessor) {
    }

    @Override
    public void visit(ListAssignment qualifier) {
        qualifier.pattern.accept(this);
        qualifier.value.accept(this);
    }

    @Override
    public void visit(ListGenerator qualifier) {
        qualifier.pattern.accept(this);
        qualifier.value.accept(this);
    }

    @Override
    public void visit(ListGuard qualifier) {
        qualifier.condition.accept(this);
    }

    @Override
    public void visit(ListSeq qualifier) {
        qualifier.a.accept(this);
        qualifier.b.accept(this);
    }

    @Override
    public void visit(ListThen qualifier) {
        qualifier.left.accept(this);
        qualifier.transformer.accept(this);
        if(qualifier.by != null)
            qualifier.by.accept(this);
    }

    @Override
    public void visit(QIf query) {
        query.condition.accept(this);
        query.thenQuery.accept(this);
        query.elseQuery.accept(this);
    }

    @Override
    public void visit(ECoveringBranchPoint expression) {
        expression.expression.accept(this);
    }

    @Override
    public void visit(EqBasic equation) {
        equation.left.accept(this);
        equation.right.accept(this);
    }

    @Override
    public void visit(EqGuard equation) {
        equation.guard.accept(this);
    }

    @Override
    public void visit(EEquations expression) {
        for(Equation equation : expression.equations)
            equation.accept(this);
    }

    @Override
    public void visit(ECHRRuleset ruleset) {
        for(CHRRule rule : ruleset.ruleset.rules) {
            for(CHRLiteral literal : rule.head.literals)
                for(Expression parameter : literal.parameters)
                    parameter.accept(this);
            for(CHRLiteral literal : rule.body.literals)
                for(Expression parameter : literal.parameters)
                    parameter.accept(this);
        }
        ruleset.in.accept(this);
    }

    @Override
    public void visit(EBinary expression) {
        expression.left.accept(this);
        for(EBinaryRightSide right : expression.rights)
            right.right.accept(this);
    }

    @Override
    public void visit(EBlock expression) {
        for(Statement stat : expression.statements)
            stat.accept(this);
    }

    @Override
    public void visit(EPreLet expression) {
        for(LetStatement stat : expression.assignments) {
            stat.pattern.accept(this);
            stat.value.accept(this);
        }
        expression.in.accept(this);
    }

    @Override
    public void visit(ERange expression) {
        expression.from.accept(this);
        expression.to.accept(this);
    }

    @Override
    public void visit(ERecord expression) {
        for(FieldAssignment assignment : expression.fields)
            assignment.value.accept(this);
        
    }

    @Override
    public void visit(EStringLiteral expression) {
        for(Expression exp : expression.expressions)
            exp.accept(this);
    }

    @Override
    public void visit(BindStatement statement) {
        statement.pattern.accept(this);
        statement.value.accept(this);
    }

    @Override
    public void visit(GuardStatement statement) {
        statement.value.accept(this);
    }

    @Override
    public void visit(LetStatement statement) {
        statement.value.accept(this);
    }

    @Override
    public void visit(RuleStatement statement) {
        statement.head.accept(this);
        statement.body.accept(this);
    }

}
