package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.equation.EqBasic;
import org.simantics.scl.compiler.elaboration.equation.EqGuard;
import org.simantics.scl.compiler.elaboration.equation.Equation;
import org.simantics.scl.compiler.elaboration.equation.EquationVisitor;
import org.simantics.scl.compiler.elaboration.expressions.accessor.ExpressionAccessor;
import org.simantics.scl.compiler.elaboration.expressions.block.BindStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.LetStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementVisitor;
import org.simantics.scl.compiler.elaboration.expressions.list.ListAssignment;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGenerator;
import org.simantics.scl.compiler.elaboration.expressions.list.ListGuard;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifier;
import org.simantics.scl.compiler.elaboration.expressions.list.ListQualifierTransformer;
import org.simantics.scl.compiler.elaboration.expressions.list.ListSeq;
import org.simantics.scl.compiler.elaboration.expressions.list.ListThen;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.query.QAlternative;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.QIf;
import org.simantics.scl.compiler.elaboration.query.QMapping;
import org.simantics.scl.compiler.elaboration.query.QNegation;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.pre.QPreBinds;
import org.simantics.scl.compiler.elaboration.query.pre.QPreEquals;
import org.simantics.scl.compiler.elaboration.query.pre.QPreExists;
import org.simantics.scl.compiler.elaboration.query.pre.QPreGuard;

public class StandardExpressionTransformer implements
ExpressionTransformer, QueryTransformer, ListQualifierTransformer, StatementVisitor,
EquationVisitor {

    @Override
    public Expression transform(EAmbiguous expression) {
        return expression;
    }

    @Override
    public Expression transform(EApply expression) {
        expression.function = expression.function.accept(this);
        for(int i=0;i<expression.parameters.length;++i)
            expression.parameters[i] = expression.parameters[i].accept(this);
        return expression;
    }

    @Override
    public Expression transform(EApplyType expression) {
        expression.expression = expression.expression.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EAsPattern expression) {
        expression.pattern = expression.pattern.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EBinary expression) {
        expression.left = expression.left.accept(this);
        for(EBinaryRightSide rs : expression.rights)
            rs.right = rs.right.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EBind expression) {
        expression.pattern = expression.pattern.accept(this);
        expression.value = expression.value.accept(this);
        expression.in = expression.in.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EViewPattern expression) {
        expression.expression = expression.expression.accept(this);
        expression.pattern = expression.pattern.accept(this);
        return expression;
    }
    
    @Override
    public Expression transform(EBlock expression) {
        for(Statement statement : expression.statements)
            statement.accept(this);
        return expression;
    }
    
    @Override
    public void visit(BindStatement statement) {
        statement.pattern = statement.pattern.accept(this);
        statement.value = statement.value.accept(this);
    }
    
    @Override
    public void visit(GuardStatement statement) {
        statement.value = statement.value.accept(this);        
    }
    
    @Override
    public void visit(LetStatement statement) {
        statement.pattern = statement.pattern.accept(this);
        statement.value = statement.value.accept(this);
    }
    
    @Override
    public void visit(RuleStatement statement) {
        statement.head = statement.head.accept(this);
        statement.body = statement.body.accept(this);
    }

    @Override
    public Expression transform(ECHRRuleset expression) {
        expression.in = expression.in.accept(this);
        for(CHRRule rule : expression.ruleset.rules) {
            for(CHRLiteral lit : rule.head.literals)
                for(int i=0;i<lit.parameters.length;++i)
                    lit.parameters[i] = lit.parameters[i].accept(this);
            for(CHRLiteral lit : rule.body.literals)
                for(int i=0;i<lit.parameters.length;++i)
                    lit.parameters[i] = lit.parameters[i].accept(this);
        }
        return expression;
    }

    @Override
    public Expression transform(EConstant expression) {
        return expression;
    }

    @Override
    public Expression transform(EEnforce expression) {
        expression.query = expression.query.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EError expression) {
        return expression;
    }

    @Override
    public Expression transform(EExternalConstant expression) {
        return expression;
    }

    @Override
    public Expression transform(EFieldAccess expression) {
        expression.parent = expression.parent.accept(this);
        if(expression.accessor instanceof ExpressionAccessor) {
        	ExpressionAccessor expAcc = (ExpressionAccessor)expression.accessor;
        	expAcc.fieldName = expAcc.fieldName.accept(this);
        }
        return expression;
    }

    @Override
    public Expression transform(EGetConstraint expression) {
        return expression;
    }

    @Override
    public Expression transform(EIf expression) {
        expression.condition = expression.condition.accept(this);
        expression.then_ = expression.then_.accept(this);
        if(expression.else_ != null)
            expression.else_ = expression.else_.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EIntegerLiteral expression) {
        return expression;
    }

    protected void transformCases(Case[] cases) {
        for(Case case_ : cases) {
            for(int i=0;i<case_.patterns.length;++i)
                case_.patterns[i] = case_.patterns[i].accept(this);
            case_.value = case_.value.accept(this);
        }
    }
    
    @Override
    public Expression transform(ELambda expression) {
        transformCases(expression.cases);
        return expression;
    }

    @Override
    public Expression transform(ELambdaType expression) {
        expression.value = expression.value.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ELet expression) {
        expression.in = expression.in.accept(this);
        for(Assignment assign : expression.assignments) {
            assign.pattern = assign.pattern.accept(this);
            assign.value = assign.value.accept(this);
        }
        return expression;
    }

    @Override
    public Expression transform(EListComprehension expression) {
        expression.head = expression.head.accept(this);
        expression.qualifier =  expression.qualifier.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EListLiteral expression) {
        for(int i=0;i<expression.components.length;++i)
            expression.components[i] = expression.components[i].accept(this);
        return expression;
    }

    @Override
    public Expression transform(ELiteral expression) {
        return expression;
    }

    @Override
    public Expression transform(EMatch expression) {
        for(int i=0;i<expression.scrutinee.length;++i)
            expression.scrutinee[i] = expression.scrutinee[i].accept(this);
        transformCases(expression.cases);
        return expression;
    }

    @Override
    public Expression transform(EPlaceholder expression) {
        expression.expression = expression.expression.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EPreLet expression) {
        for(LetStatement statement : expression.assignments) {
            statement.pattern = statement.pattern.accept(this);
            statement.value = statement.value.accept(this);
        }
        expression.in = expression.in.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EPreRuleset expression) {
        for(RuleStatement rule : expression.statements) {
            rule.body = rule.body.accept(this);
            rule.head = rule.head.accept(this);
        }
        expression.in = expression.in.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ECoveringBranchPoint expression) {
        expression.expression = expression.expression.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ERange expression) {
        expression.from = expression.from.accept(this);
        expression.to = expression.to.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ERealLiteral expression) {
        return expression;
    }

    @Override
    public Expression transform(ERecord expression) {
        for(FieldAssignment field : expression.fields)
            if(field.value != null)
                field.value = field.value.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ERuleset expression) {
        for(ERuleset.DatalogRule rule : expression.rules) {
            rule.body = rule.body.accept(this);
            for(int i=0;i<rule.headParameters.length;++i)
                rule.headParameters[i] = rule.headParameters[i].accept(this);
        }
        expression.in = expression.in.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ESelect expression) {
        expression.query = expression.query.accept(this);
        expression.expression = expression.expression.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ESimpleLambda expression) {
        expression.value = expression.value.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ESimpleLet expression) {
        expression.value = expression.value.accept(this);
        expression.in = expression.in.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EStringLiteral expression) {
        return expression;
    }

    @Override
    public Expression transform(ETransformation expression) {
        expression.seed = expression.seed.accept(this);
        return expression;
    }

    @Override
    public Expression transform(ETypeAnnotation expression) {
        expression.value = expression.value.accept(this);
        return expression;
    }

    @Override
    public Expression transform(EVar expression) {
        return expression;
    }

    @Override
    public Expression transform(EVariable expression) {
        return expression;
    }

    @Override
    public Expression transform(EWhen expression) {
        expression.query = expression.query.accept(this);
        expression.action = expression.action.accept(this);
        return expression;
    }

    @Override
    public Expression transform(GuardedExpressionGroup expression) {
        for(GuardedExpression ge : expression.expressions) {
            for(int i=0;i<ge.guards.length;++i)
                ge.guards[i] = ge.guards[i].accept(this);
            ge.value = ge.value.accept(this);
        }
        return expression;
    }

    @Override
    public ListQualifier transform(ListAssignment qualifier) {
        qualifier.pattern = qualifier.pattern.accept(this);
        qualifier.value = qualifier.value.accept(this);
        return qualifier;
    }

    @Override
    public ListQualifier transform(ListGenerator qualifier) {
        qualifier.pattern = qualifier.pattern.accept(this);
        qualifier.value = qualifier.value.accept(this);
        return qualifier;
    }

    @Override
    public ListQualifier transform(ListGuard qualifier) {
        qualifier.condition = qualifier.condition.accept(this);
        return qualifier;
    }

    @Override
    public ListQualifier transform(ListSeq qualifier) {
        qualifier.a = qualifier.a.accept(this);
        qualifier.b = qualifier.b.accept(this);
        return qualifier;
    }

    @Override
    public ListQualifier transform(ListThen qualifier) {
        qualifier.left = qualifier.left.accept(this);
        qualifier.transformer = qualifier.transformer.accept(this);
        if(qualifier.by != null)
            qualifier.by = qualifier.by.accept(this);
        return qualifier;
    }

    @Override
    public Query transform(QAlternative query) {
        for(int i=0;i<query.queries.length;++i)
            query.queries[i] = query.queries[i].accept(this);
        return query;
    }

    @Override
    public Query transform(QAtom query) {
        for(int i=0;i<query.parameters.length;++i)
            query.parameters[i] = query.parameters[i].accept(this);
        return query;
    }

    @Override
    public Query transform(QConjunction query) {
        for(int i=0;i<query.queries.length;++i)
            query.queries[i] = query.queries[i].accept(this);
        return query;
    }

    @Override
    public Query transform(QDisjunction query) {
        for(int i=0;i<query.queries.length;++i)
            query.queries[i] = query.queries[i].accept(this);
        return query;
    }

    @Override
    public Query transform(QExists query) {
        query.query = query.query.accept(this);
        return query;
    }

    @Override
    public Query transform(QIf query) {
        query.condition = query.condition.accept(this);
        query.thenQuery = query.thenQuery.accept(this);
        query.elseQuery = query.elseQuery.accept(this);
        return query;
    }

    @Override
    public Query transform(QMapping query) {
        for(int i=0;i<query.parameters.length;++i)
            query.parameters[i] = query.parameters[i].accept(this);
        return query;
    }

    @Override
    public Query transform(QNegation query) {
        query.query = query.query.accept(this);
        return query;
    }

    @Override
    public Query transform(QPreBinds query) {
        query.left = query.left.accept(this);
        query.right = query.right.accept(this);
        return query;
    }

    @Override
    public Query transform(QPreEquals query) {
        query.left = query.left.accept(this);
        query.right = query.right.accept(this);
        return query;
    }

    @Override
    public Query transform(QPreExists query) {
        query.query = query.query.accept(this);
        return query;
    }

    @Override
    public Query transform(QPreGuard query) {
        query.guard = query.guard.accept(this);
        return query;
    }

    @Override
    public Expression transform(EEquations expression) {
        for(Equation equation : expression.equations)
            equation.accept(this);
        return expression;
    }

    @Override
    public void visit(EqBasic equation) {
        equation.left =  equation.left.accept(this);
        equation.right = equation.right.accept(this);
    }

    @Override
    public void visit(EqGuard equation) {
        equation.guard =  equation.guard.accept(this);
    }

}
