package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.FunctionDefinitionLhs;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.LhsType;
import org.simantics.scl.compiler.elaboration.expressions.lhstype.PatternMatchingLhs;
import org.simantics.scl.compiler.errors.Locations;

public class EVar extends ASTExpression {
    public final String name;

    public EVar(long location, String name) {
        this.location = location;
        this.name = name;
    }
    
    public EVar(String name) {
        this(Locations.NO_LOCATION, name);
    }
   
    @Override
    public EVar getPatternHead() {
        return this;
    }
    
    @Override
    public LhsType getLhsType() throws NotPatternException {
        if(TranslationContext.isConstructorName(name))
            return new PatternMatchingLhs();
        else
            return new FunctionDefinitionLhs(name);
    }
    
    @Override
    protected void collectVariableNames(PatternMatchingLhs lhsType)
            throws NotPatternException {
        if(!TranslationContext.isConstructorName(name))
            lhsType.variableNames.add(name);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return context.resolveVariable(location, name);
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return context.resolvePattern(this);
    }
    
    @Override
    public int getFunctionDefinitionPatternArity() throws NotPatternException {
        if(TranslationContext.isConstructorName(name))
            throw new NotPatternException(this);
        else
            return 0;
    }
    
    @Override
    public boolean isConstructorApplication() {
        return TranslationContext.isConstructorName(name);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
