package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class ELiteral extends Expression {
    Constant value;
    
    public ELiteral(Constant value) {
        this.value = value;
        setType(value.getType());
    }

    public ELiteral(long loc, Constant value) {
        super(loc);
        this.value = value;
    }

    public Constant getValue() {
        return value;
    }

	public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
    }

	@Override
	public void collectVars(TObjectIntHashMap<Variable> allVars,
	        TIntHashSet vars) {	    
	}
	
	public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(value);
    }
	
	@Override
	protected void updateType() throws MatchException {
	    setType(value.getType());	    
	}

	@Override
	public IVal toVal(Environment env, CodeWriter w) {
        return value;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
    }


    @Override
    public Expression simplify(SimplificationContext context) {
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new ELiteral(value);
    }
    
    @Override
    public void removeFreeVariables(THashSet<Variable> vars) {     
    }
    
    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return new IConstant(value.realizeValue(target.localClassBuilder));
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
    }
    
    @Override
    public boolean isPattern(int arity) {
        return value.constructorTag() >= 0 && value.getArity() == arity;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public boolean equalsExpression(Expression expression) {
        if(expression.getClass() != getClass())
            return false;
        ELiteral other = (ELiteral)expression;
        return value.equals(other.value);
    }

}
