package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.singletons.NullCheck;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PostCommitOp extends PlanOp {
    int priority;
    
    public PostCommitOp(long location, int priority) {
        super(location);
        this.priority = priority;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("POST_COMMIT " + priority);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        if(planContext.currentId != null) {
            w.apply(location, planContext.ruleset.writeCurrentId, planContext.storeVar, planContext.currentId);
            planContext.currentId = null;
            w.apply(location, planContext.ruleset.activateProcedure, planContext.storeVar, new IntegerConstant(priority));
        }
        for(PartnerFact activeFact : planContext.partnerFacts) {
            if(activeFact.killAfterMatch) {
                if(activeFact.nextFact == null)
                    w.jump(activeFact.finishCont);
                else {
                    CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
                    w.jump(iterateAlive.getContinuation(), w.apply(location, activeFact.nextFact, activeFact.factVar));
                    iterateUntilLiveFactFound(iterateAlive, activeFact);                    
                }
                break;
            }
            else if(activeFact.mayBeRemoved) {
                if(activeFact.nextFact == null) {
                    w.branchAwayUnless(activeFact.isAlive(location, w), activeFact.finishCont);
                }
                else {
                    CodeWriter failure = w.createBlock();
                    CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
                    w.branchAwayUnless(activeFact.isAlive(location, w), failure.getContinuation());
                    failure.jump(iterateAlive.getContinuation(), failure.apply(location, activeFact.nextFact, activeFact.factVar));
                    iterateUntilLiveFactFound(iterateAlive, activeFact);     
                }
            }
        }
        // PostCommit does not call nextOp
    }
    
    private void iterateUntilLiveFactFound(CodeWriter w, PartnerFact activeFact) {
        ICont initialContinuation = w.getContinuation();
        CHRConstraint constraint = activeFact.constraint;
        IVal fact = w.getParameters()[0];
        CodeWriter dead = w.createBlock();
        w.branchAwayIf(w.apply(location, NullCheck.INSTANCE.createSpecialization(constraint.factType), fact), activeFact.finishCont);
        w.branchAwayUnless(activeFact.isAlive(location, w, fact), dead.getContinuation());
        w.jump(activeFact.continueCont, fact);
        dead.jump(initialContinuation, dead.apply(location, activeFact.nextFact, fact));
    }

}
