package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class CheckOp extends PlanOp {
    public Expression condition;

    public CheckOp(long location, Expression condition) {
        super(location);
        this.condition = condition;
    }
    
    @Override
    public void toString(StringBuilder b) {
        b.append("CHECK   ").append(condition);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        planContext.check(location, w, condition.toVal(context.environment, w));
    }
}
