package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class AssignOp extends PlanOp {
    public Variable variable;
    public Expression expression;
   
    public AssignOp(long location, Variable variable, Expression expression) {
        super(location);
        this.variable = variable;
        this.expression = expression;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("ASSIGN  ").append(variable).append(" = ").append(expression);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        variable.setVal(expression.toVal(context.environment, w));
        planContext.nextOp(w);
    }

    
}
