/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ScheduledFuture;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.Quality;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.ExecutorWorker;

public class NavigationNode
extends TransformNode
implements PropertyChangeListener {
    private static final long serialVersionUID = -2561419753994187972L;
    protected Rectangle2D bounds = null;
    protected Boolean visible = Boolean.TRUE;
    protected Boolean adaptViewportToResizedControl = Boolean.TRUE;
    protected Double zoomInLimit = null;
    protected Double zoomOutLimit = null;
    protected Boolean navigationEnabled = Boolean.TRUE;
    protected Boolean zoomEnabled = Boolean.TRUE;
    protected Quality lowQualityMode = Quality.LOW;
    protected Quality highQualityMode = Quality.HIGH;
    protected Quality staticQualityMode = Quality.LOW;
    protected Boolean dynamicQuality = Boolean.TRUE;
    private TransformListener transformListener = null;
    private static final int REPAINT_DELAY = 250;
    private transient boolean qualityPaint = true;
    private transient ScheduledFuture<Object> pendingTask;
    protected transient Point2D dragDelta = null;
    transient Rectangle r = new Rectangle();
    protected transient Rectangle2D performZoomTo = null;

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.removeEventHandler(this);
        super.cleanup();
    }

    @INode.SyncField(value={"bounds"})
    protected void setBounds(Rectangle2D bounds) {
        this.bounds = (Rectangle2D)bounds.clone();
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    @INode.SyncField(value={"visible"})
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @INode.SyncField(value={"navigationEnabled"})
    public void setNavigationEnabled(Boolean navigationEnabled) {
        this.navigationEnabled = navigationEnabled;
    }

    @INode.SyncField(value={"zoomEnabled"})
    public void setZoomEnabled(Boolean zoomEnabled) {
        this.zoomEnabled = zoomEnabled;
    }

    @INode.SyncField(value={"lowQualityMode"})
    public void setLowQualityMode(Quality mode) {
        this.lowQualityMode = mode;
    }

    @INode.SyncField(value={"highQualityMode"})
    public void setHighQualityMode(Quality mode) {
        this.highQualityMode = mode;
    }

    @INode.SyncField(value={"staticQualityMode"})
    public void setStaticQualityMode(Quality mode) {
        this.staticQualityMode = mode;
    }

    public Quality getStaticQualityMode() {
        return this.staticQualityMode;
    }

    @INode.SyncField(value={"dynamicQuality"})
    public void setDynamicQuality(Boolean dynamicQuality) {
        this.dynamicQuality = dynamicQuality;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.SyncField(value={"adaptViewportToResizedControl"})
    public void setAdaptViewportToResizedControl(Boolean adapt) {
        this.adaptViewportToResizedControl = adapt;
    }

    public boolean getAdaptViewportToResizedControl() {
        return this.adaptViewportToResizedControl;
    }

    @INode.SyncField(value={"zoomOutLimit"})
    public void setZoomOutLimit(Double zoomOutLimit) {
        this.zoomOutLimit = zoomOutLimit;
    }

    @INode.SyncField(value={"zoomInLimit"})
    public void setZoomInLimit(Double zoomInLimit) {
        this.zoomInLimit = zoomInLimit;
    }

    public Double getZoomInLimit() {
        return this.zoomInLimit;
    }

    public Double getZoomOutLimit() {
        return this.zoomOutLimit;
    }

    protected double limitScaleFactor(double scaleFactor) {
        Double inLimit = this.zoomInLimit;
        Double outLimit = this.zoomOutLimit;
        if (inLimit == null && scaleFactor < 1.0) {
            return scaleFactor;
        }
        if (outLimit == null && scaleFactor > 1.0) {
            return scaleFactor;
        }
        AffineTransform view = this.transform;
        double currentScale = GeometryUtils.getScale(view) * 100.0;
        double newScale = currentScale * scaleFactor;
        if (inLimit != null && newScale > currentScale && newScale > inLimit) {
            scaleFactor = currentScale < inLimit ? inLimit / currentScale : 1.0;
        } else if (outLimit != null && newScale < currentScale && newScale < outLimit) {
            scaleFactor = currentScale > outLimit ? outLimit / currentScale : 1.0;
        }
        return scaleFactor;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle newBounds = g2d.getClipBounds(this.r);
        if (!newBounds.equals(this.bounds)) {
            if (this.bounds != null && Boolean.TRUE.equals(this.adaptViewportToResizedControl)) {
                double scale = Math.sqrt(newBounds.getWidth() * newBounds.getWidth() + newBounds.getHeight() * newBounds.getHeight()) / Math.sqrt(this.bounds.getWidth() * this.bounds.getWidth() + this.bounds.getHeight() * this.bounds.getHeight());
                AffineTransform tr = (AffineTransform)this.transform.clone();
                tr.preConcatenate(new AffineTransform(new double[]{scale, 0.0, 0.0, scale, 0.0, 0.0}));
                this.setTransform(tr);
                this.transformChanged();
            }
            this.setBounds(newBounds);
        }
        if (this.bounds != null && this.performZoomTo != null) {
            this.setTransform(GeometryUtils.fitArea(this.bounds, this.performZoomTo));
            this.performZoomTo = null;
            this.transformChanged();
        }
        if (this.visible.booleanValue()) {
            QualityHints qualityHints;
            QualityHints origQualityHints = null;
            Quality mode = null;
            if (this.dynamicQuality.booleanValue()) {
                mode = this.qualityPaint ? this.highQualityMode : this.lowQualityMode;
            } else if (this.staticQualityMode != null) {
                mode = this.staticQualityMode;
            }
            if (mode != null && (qualityHints = QualityHints.getHints(mode)) != null) {
                origQualityHints = QualityHints.getQuality(g2d);
                qualityHints.setQuality(g2d);
            }
            super.render(g2d);
            if (origQualityHints != null) {
                origQualityHints.setQuality(g2d);
            }
        }
    }

    @INode.ClientSide
    public void zoomTo(Rectangle2D diagram) {
        this.performZoomTo = diagram;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [visible=" + this.visible + ", bounds=" + this.bounds + ", zoomInLimit=" + this.zoomInLimit + ", zoomOutLimit=" + this.zoomOutLimit + ", adaptViewportToResize=" + this.adaptViewportToResizedControl + "]";
    }

    private void transformChanged() {
        if (this.transformListener != null) {
            this.transformListener.transformChanged(this.transform);
        }
    }

    public void setTransformListener(TransformListener listener) {
        this.transformListener = listener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.transformListener != null && "transform".equals(evt.getPropertyName())) {
            this.transformListener.transformChanged((AffineTransform)evt.getNewValue());
        }
    }

    @Override
    public boolean mouseWheelMoved(MouseEvent.MouseWheelMovedEvent me) {
        if (this.navigationEnabled.booleanValue() && this.zoomEnabled.booleanValue()) {
            double scroll = Math.min(0.9, (double)(-me.wheelRotation) / 20.0);
            double z = 1.0 - scroll;
            double dx = (me.controlPosition.getX() - this.transform.getTranslateX()) / this.transform.getScaleX();
            double dy = (me.controlPosition.getY() - this.transform.getTranslateY()) / this.transform.getScaleY();
            dx *= 1.0 - z;
            dy *= 1.0 - z;
            double limitedScale = this.limitScaleFactor(z);
            if (limitedScale != 1.0) {
                this.translate(dx, dy);
                this.scale(z, z);
                this.transformChanged();
                this.dropQuality();
                this.repaint();
            }
        }
        return false;
    }

    @Override
    public boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        if (this.navigationEnabled.booleanValue() && this.isPanState(e)) {
            this.dragDelta = new Point2D.Double(e.controlPosition.getX(), e.controlPosition.getY());
        }
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        if (this.navigationEnabled.booleanValue() && this.dragDelta != null && this.isPanState(e)) {
            double x = (e.controlPosition.getX() - this.dragDelta.getX()) / this.transform.getScaleX();
            double y = (e.controlPosition.getY() - this.dragDelta.getY()) / this.transform.getScaleY();
            this.translate(x, y);
            this.transformChanged();
            this.dragDelta = new Point2D.Double(e.controlPosition.getX(), e.controlPosition.getY());
            this.dropQuality();
            this.repaint();
            return true;
        }
        return false;
    }

    protected boolean isPanState(MouseEvent e) {
        boolean anyPanButton = e.hasAnyButton(6);
        boolean middle = e.hasAnyButton(4);
        boolean shift = e.hasAnyModifier(64);
        return middle || anyPanButton && shift;
    }

    private void dropQuality() {
        if (!this.dynamicQuality.booleanValue()) {
            return;
        }
        if (this.pendingTask != null) {
            this.pendingTask.cancel(false);
            this.pendingTask = null;
        }
        this.qualityPaint = false;
        this.scheduleRepaint();
    }

    private void scheduleRepaint() {
        Executable exe = new Executable(AWTThread.getThreadAccess(), new Runnable(){

            @Override
            public void run() {
                NavigationNode.this.qualityPaint = true;
                NavigationNode.this.repaint();
            }
        });
        this.pendingTask = ExecutorWorker.getInstance().timerExec(exe, 250);
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseMovedMask | EventTypes.MouseButtonPressedMask | EventTypes.MouseWheelMask;
    }

    public static interface TransformListener {
        public void transformChanged(AffineTransform var1);
    }
}

