/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.simantics.scenegraph.g2d.G2DNode;

public class ImageNode extends G2DNode {

    private static final long serialVersionUID = -4982578347433716440L;

    protected Boolean visible = Boolean.TRUE;
    protected BufferedImage img = null;

    @SyncField("visible")
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return visible;
    }

    @ClientSide
    public void setImage(byte[] buf) {
        try {
            img = ImageIO.read(new ByteArrayInputStream(buf));
        } catch (IOException e) {
        }
    }

    public void setImage(BufferedImage src) {
        img = src;
    }

    @Override
    public void render(Graphics2D g) {
        if (!visible || img == null) return;

        AffineTransform ot = null;
        if (!transform.isIdentity()) {
            ot = g.getTransform();
            g.transform(transform);
        }

//        G2DParentNode parent = (G2DParentNode) getParent();
//        if(parent != null) {
//            Rectangle2D b = parent.getBoundsInLocal();
//            g.drawImage(img, (int)b.getMinX(), (int)b.getMinY(), (int)b.getWidth()+(int)b.getMinX(), (int)b.getHeight()+(int)b.getMinY(), 0, 0, img.getWidth(), img.getHeight(), null);
//        }
        g.drawImage(img, 0, 0, null);

        if (ot != null)
            g.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return new Rectangle2D.Double(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight());
    }

}
