/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class BranchPointNode extends G2DNode {
    private static final long serialVersionUID = -5838113741617205901L;

//    public static final Shape SHAPE = new Ellipse2D.Double(-.5, -.5, 1, 1);
//    public static final Shape SHAPE2 = new Rectangle2D.Double(-.3, -.3, .6, .6);
    public static final Shape SHAPE = new Ellipse2D.Double(-.5, -.5, 1, 1);
    public static final Shape SHAPE2 = new Rectangle2D.Double(-.5, -.5, 1, 1);

    public static final Stroke STROKE = new BasicStroke(0.1f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER);

    Integer degree = 0;
    // 0 == any, 1 == horizontal, 2 == vertical
    Byte direction = 0;

    @SyncField("degree")
    public void setDegree(int degree) {
        this.degree = degree;
    }

    @SyncField("direction")
    public void setDirection(byte direction) {
        this.direction = direction;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform oldTransform = g.getTransform();
        if (transform != null)
            g.transform(transform);

        try {
            renderBranchpoint(g);
        } finally {
            g.setTransform(oldTransform);
        }
    }

    private void renderBranchpoint(Graphics2D g) {
        boolean selected = NodeUtil.isSelected(this, 2);
        if (degree <= 2) {
            if (selected) {
                g.setPaint(Color.GREEN);
                g.fill(SHAPE2);
                g.setPaint(Color.BLACK);
                g.setStroke(STROKE);
                g.draw(SHAPE2);
            } else {
                //g.setPaint(new Color(128,128,128,64));
                g.setPaint(Color.LIGHT_GRAY);
                g.fill(SHAPE2);
            }
        } else {
            if (selected) {
                g.setPaint(Color.GREEN);
                //g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fill(SHAPE);
                g.setPaint(Color.BLACK);
                g.setStroke(STROKE);
                g.draw(SHAPE);
            } else {
                g.setPaint(Color.BLACK);
                //g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fill(SHAPE);
            }
        }

        if (direction != 0) {
            g.setStroke(STROKE);
            g.setColor(degree <= 2 ? Color.BLACK : (selected ? Color.BLACK : Color.GREEN));
            if (direction == 1) {
                // Horizontal
                g.draw(new Line2D.Double(-.5, 0, .5, 0));
            } else if (direction == 2) {
                // Vertical
                g.draw(new Line2D.Double(0, -.5, 0, .5));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [degree=" + degree + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        Shape shp = SHAPE;
        if (degree <= 2) {
            shp = SHAPE2;
        }
        return shp.getBounds2D();
    }
}
