/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;

public class BackgroundNode extends G2DNode {
    /**
     * 
     */
    private static final long serialVersionUID = 2805713128639560702L;

    protected Color color = null;
    protected Paint paint = null;
    protected Rectangle2D bounds = null;

    @SyncField("color")
    public void setColor(Color color) {
        this.color = color;
    }

    @SyncField("paint")
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @SyncField("bounds")
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public void render(Graphics2D g) {
    	Rectangle2D drawBounds = bounds;
        if(drawBounds == null) {
        	drawBounds = (Rectangle2D)g.getClipBounds().clone(); // Fill whole clip area if bounds is not defined
        }
        
        if (color!=null) {
            g.setColor(color);
            g.fill(drawBounds);
        } else
            if (paint!=null) {
                g.setPaint(paint);
                g.fill(drawBounds);
            }
    }

    @Override
    public String toString() {
        return super.toString() + " [color=" + color + "]";
    }

	@Override
	public Rectangle2D getBoundsInLocal() {
		return bounds;
	}
}
