/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.rules.domain.StructuralUtils;

public class StructuralRelatedObjectAccessor
implements IDomainAccessor<StructuralResource, StructuralResource> {
    static Logger LOGGER = Logger.getLogger((String)"org.simantics.objmap");
    Resource relation;
    boolean useTypeResource;
    private boolean preventStructuralChanges = true;
    private boolean preventStructuralRootChanges = true;

    public StructuralRelatedObjectAccessor(Resource relation, boolean useTypeResource) {
        this.relation = relation;
        this.useTypeResource = useTypeResource;
    }

    public StructuralRelatedObjectAccessor(Resource relation, boolean useTypeResource, boolean preventStructuralChanges, boolean preventStructuralRootChanges) {
        this.relation = relation;
        this.useTypeResource = useTypeResource;
        this.preventStructuralChanges = preventStructuralChanges;
        this.preventStructuralRootChanges = preventStructuralRootChanges;
    }

    private boolean preventChange(StructuralResource element) {
        return this.preventStructuralChanges && element.isStructural() && (!element.isStructuralRoot() || this.preventStructuralRootChanges);
    }

    @Override
    public StructuralResource get(ReadGraph g, StructuralResource element) throws MappingException {
        Resource r;
        block9: {
            Resource publicRelation;
            Resource instance;
            block8: {
                block7: {
                    LOGGER.info((Object)"        RelatedObjectAccessor.get");
                    if (element.isStructural()) break block7;
                    return null;
                }
                instance = StructuralUtils.getContainingInstance(element);
                publicRelation = StructuralUtils.getPublishedRelation(g, element, this.relation);
                if (publicRelation != null) break block8;
                return null;
            }
            r = g.getPossibleObject(instance, publicRelation);
            if (r != null) break block9;
            return null;
        }
        try {
            ArrayList<Resource> context = new ArrayList<Resource>();
            int i = 0;
            while (i < element.getContext().size() - 1) {
                context.add(element.getContext().get(i));
                ++i;
            }
            if (StructuralUtils.isStructuralInstance(g, r)) {
                return new StructuralResource(g, r, context, r);
            }
            return new StructuralResource(g, r, context);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, StructuralResource element, StructuralResource value) throws MappingException {
        Resource publicRelation;
        Resource instance;
        block21: {
            block20: {
                Resource r;
                block18: {
                    block19: {
                        block16: {
                            block17: {
                                block13: {
                                    block15: {
                                        block14: {
                                            block12: {
                                                try {
                                                    LOGGER.info((Object)"        RelatedObjectAccessor.set");
                                                    instance = StructuralUtils.getContainingInstance(element);
                                                    publicRelation = null;
                                                    if (instance != null) break block12;
                                                    return false;
                                                }
                                                catch (DatabaseException e) {
                                                    throw new MappingException(e);
                                                }
                                            }
                                            publicRelation = StructuralUtils.getPublishedRelation((ReadGraph)g, element, this.relation);
                                            if (value != null) break block13;
                                            if (publicRelation != null) break block14;
                                            return false;
                                        }
                                        if (!this.preventChange(element)) break block15;
                                        return false;
                                    }
                                    g.deny(instance, publicRelation);
                                    return true;
                                }
                                if (publicRelation != null) break block16;
                                if (!this.preventChange(element)) break block17;
                                return false;
                            }
                            publicRelation = StructuralUtils.getOrCreatePublishedRelation(g, element, this.relation);
                            g.claim(instance, publicRelation, value.getResource());
                            return true;
                        }
                        r = g.getPossibleObject(instance, publicRelation);
                        if (r != null) break block18;
                        if (!this.preventChange(element)) break block19;
                        return false;
                    }
                    g.claim(instance, publicRelation, value.getResource());
                    return true;
                }
                if (!r.equals(value.getResource())) break block20;
                return false;
            }
            if (!this.preventChange(element)) break block21;
            return false;
        }
        g.deny(instance, publicRelation);
        g.claim(instance, publicRelation, value.getResource());
        return true;
    }
}

