/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.CompoundRelatedGetValue;
import org.simantics.objmap.graph.annotations.CompoundRelatedSetValue;
import org.simantics.objmap.graph.rules.ValueRule;
import org.simantics.objmap.graph.rules.domain.CompoundValueAccessor;
import org.simantics.objmap.graph.rules.factory.IGetSetRuleFactory;
import org.simantics.objmap.graph.rules.range.CompoundGetSetValueAccessor;

public class CompoundRelatedGetSetValueRuleFactory<Range>
implements IGetSetRuleFactory<Resource, Range> {
    @Override
    public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation annotation, Method getter, Method setter) throws DatabaseException {
        CompoundRelatedGetValue getterAnn = (CompoundRelatedGetValue)annotation;
        CompoundGetSetValueAccessor rangeAccessor = new CompoundGetSetValueAccessor(getter, setter);
        return new ValueRule(new CompoundValueAccessor(g.getResource(getterAnn.objRelation()), g.getResource(getterAnn.objType()), g.getResource(getterAnn.valRelation())), rangeAccessor);
    }

    @Override
    public boolean isSetter(Annotation getterAnnotation, Annotation annotation) {
        CompoundRelatedGetValue getterAnn = (CompoundRelatedGetValue)getterAnnotation;
        CompoundRelatedSetValue setterAnn = (CompoundRelatedSetValue)annotation;
        return getterAnn.objRelation().equals(setterAnn.value());
    }

    public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return b.Double;
        }
        if (clazz.equals(String.class)) {
            return b.String;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return b.Integer;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return b.Float;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return b.Boolean;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return b.Long;
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return b.Byte;
        }
        if (clazz.equals(double[].class)) {
            return b.DoubleArray;
        }
        if (clazz.equals(int[].class)) {
            return b.IntegerArray;
        }
        if (clazz.equals(byte[].class)) {
            return b.ByteArray;
        }
        if (clazz.equals(float[].class)) {
            return b.FloatArray;
        }
        if (clazz.equals(boolean[].class)) {
            return b.BooleanArray;
        }
        if (clazz.equals(String[].class)) {
            return b.StringArray;
        }
        if (clazz.equals(long[].class)) {
            return b.LongArray;
        }
        System.out.println("Couldn't find a data type for " + clazz);
        return null;
    }
}

