/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.layer0.migration.MigratedImportResult;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.ModelImportAdvisor;
import org.simantics.db.management.ISessionContext;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.ui.sharedontology.wizard.ImportPlan;
import org.simantics.modeling.ui.sharedontology.wizard.ModelImportPage;
import org.simantics.modeling.ui.sharedontology.wizard.Preferences;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.strings.EString;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.InfoDialog;

public class ModelImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    ImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new ImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        this.importModel.selection = selection.getFirstElement();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public ModelImportWizard() {
        this.setWindowTitle("Import Model");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new ModelImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Model"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            final MigratedImportResult[] result = new MigratedImportResult[1];
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            Resource target = ResourceAdaptionUtils.toSingleResource((Object)ModelImportWizard.this.importModel.selection);
                            ModelImportWizard.this.importModel.sessionContext.getSession().markUndoPoint();
                            result[0] = ModelImportWizard.doImport(monitor, ModelImportWizard.this.importModel.importLocation, ModelImportWizard.this.importModel.sessionContext.getSession(), target);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (result[0].hasMissingExternals()) {
                InfoDialog.open((Shell)this.getShell(), (String)"Missing Externals Created", (String)("The system was unable to find some of the external entities referenced by the imported material. Place-holders have been created for the missing entities.\nThe missing entities are:\n" + EString.implode((Collection)result[0].tgResult.missingExternals)), (int)0x10000000);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (cause instanceof MissingDependencyException) {
                cp.setErrorMessage("Failed to import model due to missing dependencies.\n" + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import failed due to missing database dependencies. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Failed to import model due to missing dependencies.\n\n" + cause.getMessage()), null);
            } else {
                cp.setErrorMessage("Unexpected problem importing model.\nMessage: " + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import failed unexpectedly. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Unexpected problem importing model.\n\n" + cause.getMessage()), (Throwable)cause);
            }
            return false;
        }
        catch (InterruptedException e) {
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage("Import interrupted.\nMessage: " + e.getMessage());
            ErrorLogger.defaultLogError((String)("Model " + this.importModel.importLocation + " import interrupted."), (Throwable)e);
            ExceptionUtils.showError((String)"Model import was interrupted.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static MigratedImportResult doImport(final IProgressMonitor monitor, final File modelFile, final Session session, Resource target) throws Exception {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask("Loading model from disk", 1000);
        FormatHandler<MigratedImportResult> handler1 = new FormatHandler<MigratedImportResult>(){

            public Binding getBinding() {
                return TransferableGraph1.BINDING;
            }

            public MigratedImportResult process(DataContainer container) throws Exception {
                mon.worked(100);
                mon.setTaskName("Importing model into database");
                MigrationState state = MigrationUtils.newState();
                state.setProperty("updateDependencies", (Object)false);
                state.setProperty("modelFile", (Object)modelFile);
                state.setProperty("session", (Object)session);
                state.setProperty("progressMonitor", (Object)monitor);
                MigrationUtils.importMigrated((IProgressMonitor)monitor, (Session)session, (File)modelFile, (MigrationState)state, (IImportAdvisor)new ModelImportAdvisor(Simantics.getProjectResource()), (Resource)Simantics.getProjectResource());
                Collection resultRoots = (Collection)state.getProperty("currentRootResources");
                ImportResult result = (ImportResult)state.getProperty("importResult");
                return new MigratedImportResult(resultRoots, result);
            }
        };
        HashMap<String, 2> handlers = new HashMap<String, 2>();
        handlers.put(":1", handler1);
        handlers.put("model:1", handler1);
        MigratedImportResult result = (MigratedImportResult)DataContainers.readFile((File)modelFile, handlers);
        mon.setTaskName("Postprocessing");
        mon.subTask("");
        mon.newChild(50).done();
        return result;
    }
}

