/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.ErrorLogger;

public class TypicalPropertyTester
extends PropertyTester {
    private static final String IS_TYPICAL_MASTER_EDITOR = "isMasterEditor";
    private static final String IS_TYPICAL_INSTANCE_EDITOR = "isInstanceEditor";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Resource inputResource;
        Session session;
        block11: {
            IEditorInput in;
            block10: {
                block9: {
                    block8: {
                        session = Simantics.peekSession();
                        if (session != null) break block8;
                        return false;
                    }
                    if (receiver instanceof IEditorPart) break block9;
                    return false;
                }
                IEditorPart editor = (IEditorPart)receiver;
                in = editor.getEditorInput();
                if (in instanceof IResourceEditorInput) break block10;
                return false;
            }
            IResourceEditorInput input = (IResourceEditorInput)in;
            inputResource = input.getResource();
            if (!DatabaseJob.inProgress()) break block11;
            return true;
        }
        try {
            if (IS_TYPICAL_MASTER_EDITOR.equals(property)) {
                return TypicalPropertyTester.isTypicalMasterEditor((RequestProcessor)session, inputResource);
            }
            if (IS_TYPICAL_INSTANCE_EDITOR.equals(property)) {
                return TypicalPropertyTester.isTypicalInstanceEditor((RequestProcessor)session, inputResource);
            }
        }
        catch (InterruptedException | DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return false;
    }

    public static boolean isTypicalMasterEditor(RequestProcessor processor, final Resource editorInputResource) throws DatabaseException, InterruptedException {
        return (Boolean)RequestUtil.trySyncRequest((Session)Simantics.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource composite = graph.getPossibleObject(editorInputResource, MOD.DiagramToComposite);
                if (composite != null && graph.isInstanceOf(composite, MOD.MasterTypicalCompositeType)) {
                    return true;
                }
                return false;
            }
        });
    }

    public static boolean isTypicalInstanceEditor(RequestProcessor processor, final Resource editorInputResource) throws DatabaseException, InterruptedException {
        return (Boolean)RequestUtil.trySyncRequest((Session)Simantics.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                if (graph.isInstanceOf(editorInputResource, DIA.Diagram) && graph.hasStatement(editorInputResource, MOD.HasDiagramSource)) {
                    return true;
                }
                return false;
            }
        });
    }
}

