/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.common.views.DefaultFilterStrategy;
import org.simantics.browsing.ui.common.views.IFilterStrategy;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class PDFExportPage
extends WizardPage {
    protected Display display;
    protected PDFExportPlan exportModel;
    protected IFilterStrategy filterStrategy = new DefaultFilterStrategy();
    protected Combo modelSelector;
    protected SelectionListener modelSelectorListener;
    protected Text filter;
    protected Matcher matcher = null;
    protected CheckboxTreeViewer tree;
    protected CCombo exportLocation;
    protected ModifyListener exportLocationListener;
    protected Set<Node> selectedNodes;
    protected LocalResourceManager resourceManager;
    protected Color noDiagramColor;
    protected Label toFileLabel;
    protected boolean exportLocationTouchedByUser = false;
    ICheckStateProvider checkStateProvider = new ICheckStateProvider(){

        public boolean isChecked(Object element) {
            Node node = (Node)element;
            Collection children = node.getChildren();
            if (!children.isEmpty()) {
                for (Node child : node.getChildren()) {
                    if (!this.isChecked(child)) continue;
                    return true;
                }
                return false;
            }
            return PDFExportPage.this.selectedNodes.contains(node);
        }

        public boolean isGrayed(Object element) {
            Node node = (Node)element;
            Collection children = node.getChildren();
            if (!children.isEmpty()) {
                for (Node child : children) {
                    if (PDFExportPage.this.selectedNodes.contains(child)) continue;
                    return true;
                }
            }
            return node.getDiagramResource() == null;
        }
    };

    protected PDFExportPage(PDFExportPlan model) {
        super("Export Diagrams to PDF", "Define Exported Items", null);
        this.exportModel = model;
        this.selectedNodes = this.exportModel.selectedNodeSet;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PDFExportPage.this.resourceManager.dispose();
            }
        });
        this.noDiagramColor = container.getDisplay().getSystemColor(16);
        Label modelSelectorLabel = new Label(container, 0);
        modelSelectorLabel.setText("Model Selector:");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)modelSelectorLabel);
        this.modelSelector = new Combo(container, 2056);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.modelSelector);
        this.modelSelectorListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedResource data = (NamedResource)PDFExportPage.this.modelSelector.getData(String.valueOf(PDFExportPage.this.modelSelector.getSelectionIndex()));
                PDFExportPage.this.scheduleInitializeData(data);
            }
        };
        int i = 0;
        while (i < this.exportModel.selectableModels.size()) {
            NamedResource nr = this.exportModel.selectableModels.get(i);
            this.modelSelector.add(nr.getName());
            this.modelSelector.setData("" + i, (Object)nr);
            ++i;
        }
        this.modelSelector.addSelectionListener(this.modelSelectorListener);
        Label filterLabel = new Label(container, 0);
        filterLabel.setText("Fi&lter:");
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)filterLabel);
        this.filter = new Text(container, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.filter);
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDFExportPage.this.resetFilterString(PDFExportPage.this.filter.getText());
            }
        });
        this.tree = new CheckboxTreeViewer(container, 67586);
        this.tree.setUseHashlookup(true);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo(this.tree.getControl());
        this.tree.getControl().setToolTipText("Selects the diagram to include in the exported document.");
        this.tree.setAutoExpandLevel(-1);
        this.tree.addCheckStateListener(new ICheckStateListener(){

            void addOrRemoveSelection(Node node, boolean add) {
                if (add) {
                    PDFExportPage.this.selectedNodes.add(node);
                } else {
                    PDFExportPage.this.selectedNodes.remove(node);
                }
            }

            void addOrRemoveSelectionRec(Node node, boolean add) {
                this.addOrRemoveSelection(node, add);
                for (Node child : node.getChildren()) {
                    this.addOrRemoveSelectionRec(child, add);
                }
            }

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                Node checkedNode = (Node)event.getElement();
                HashSet<Node> nodes = new HashSet<Node>();
                Set selection = ISelectionUtils.filterSetSelection((Object)PDFExportPage.this.tree.getSelection(), Node.class);
                if (selection.contains(checkedNode)) {
                    nodes.addAll(selection);
                } else {
                    PDFExportPage.this.tree.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                nodes.add(checkedNode);
                for (Node node : nodes) {
                    this.addOrRemoveSelectionRec(node, checked);
                }
                PDFExportPage.this.refreshAndExpandTree();
                PDFExportPage.this.validatePage();
            }
        });
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return PDFExportPage.this.exportModel.nodes.roots.toArray();
            }

            public boolean hasChildren(Object element) {
                Node n = (Node)element;
                if (n.getChildren().isEmpty()) {
                    return false;
                }
                for (Node c : n.getChildren()) {
                    if (!this.hasDiagram(c)) continue;
                    return true;
                }
                return false;
            }

            public Object getParent(Object element) {
                Node n = (Node)element;
                return n.getParent();
            }

            public Object[] getChildren(Object parentElement) {
                Node n = (Node)parentElement;
                ArrayList<Node> result = new ArrayList<Node>(n.getChildren().size());
                for (Node c : n.getChildren()) {
                    if (!this.hasDiagram(c)) continue;
                    result.add(c);
                }
                return result.toArray();
            }

            boolean hasDiagram(Node n) {
                if (n.getDiagramResource() != null) {
                    return true;
                }
                for (Node c : n.getChildren()) {
                    if (!this.hasDiagram(c)) continue;
                    return true;
                }
                return false;
            }
        });
        this.tree.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object e = cell.getElement();
                if (e instanceof Node) {
                    Node n = (Node)e;
                    String name = DiagramPrinter.formDiagramName(n, false);
                    cell.setText(name);
                    if (n.getDiagramResource() == null) {
                        cell.setForeground(PDFExportPage.this.noDiagramColor);
                    } else {
                        cell.setForeground(null);
                    }
                } else {
                    cell.setText("invalid input: " + e.getClass().getSimpleName());
                }
            }
        });
        this.tree.setComparator(new ViewerComparator((Comparator)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR));
        this.tree.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (PDFExportPage.this.matcher == null) {
                    return true;
                }
                Node node = (Node)element;
                for (Node child : node.getChildren()) {
                    if (!this.select(viewer, element, child)) continue;
                    return true;
                }
                return PDFExportPage.this.matcher.reset(node.getName().toLowerCase()).matches();
            }
        }});
        this.tree.setCheckStateProvider(this.checkStateProvider);
        Composite bar = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)bar);
        bar.setLayout((Layout)new RowLayout());
        Button selectAll = new Button(bar, 8);
        selectAll.setText("Select &All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.selectedNodes.addAll(PDFExportPage.this.exportModel.nodes.breadthFirstFlatten());
                for (Node root : PDFExportPage.this.exportModel.nodes.roots) {
                    PDFExportPage.this.tree.setSubtreeChecked((Object)root, true);
                }
                PDFExportPage.this.validatePage();
            }
        });
        Button clearSelection = new Button(bar, 8);
        clearSelection.setText("&Clear Selection");
        clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.selectedNodes.clear();
                for (Node root : PDFExportPage.this.exportModel.nodes.roots) {
                    PDFExportPage.this.tree.setSubtreeChecked((Object)root, false);
                }
                PDFExportPage.this.validatePage();
            }
        });
        Button selectVisible = new Button(bar, 8);
        selectVisible.setText("&Select Visible");
        selectVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.selectedNodes.addAll(PDFExportPage.this.getVisibleNodes());
                PDFExportPage.this.refreshAndExpandTree();
                PDFExportPage.this.validatePage();
            }
        });
        Button deselectVisible = new Button(bar, 8);
        deselectVisible.setText("&Deselect Visible");
        deselectVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.selectedNodes.removeAll(PDFExportPage.this.getVisibleNodes());
                PDFExportPage.this.refreshAndExpandTree();
                PDFExportPage.this.validatePage();
            }
        });
        this.toFileLabel = new Label(container, 0);
        this.toFileLabel.setText("&To file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        this.exportLocationListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PDFExportPage.this.exportLocationTouchedByUser = true;
                PDFExportPage.this.validatePage();
            }
        };
        this.exportLocation.addModifyListener(this.exportLocationListener);
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(PDFExportPage.this.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.pdf"});
                dialog.setFilterNames(new String[]{"PDF Document"});
                String loc = PDFExportPage.this.exportLocation.getText();
                if (loc != null) {
                    Path p = new Path(loc);
                    File f = p.toFile();
                    if (f.isDirectory()) {
                        dialog.setFilterPath(f.toString());
                    } else if (f.isFile()) {
                        IPath path = p.removeLastSegments(1);
                        String name = p.lastSegment();
                        dialog.setFilterPath(path.toOSString());
                        dialog.setFileName(name);
                    } else {
                        dialog.setFilterPath(f.toString());
                        IPath path = p.removeLastSegments(1);
                        String name = p.lastSegment();
                        f = path.toFile();
                        if (f.isDirectory()) {
                            dialog.setFilterPath(path.toOSString());
                        }
                        dialog.setFileName(name);
                    }
                }
                if ((file = dialog.open()) == null) {
                    return;
                }
                PDFExportPage.this.exportLocation.setText(file);
                PDFExportPage.this.validatePage();
            }
        });
        final Button zoomToFitButton = new Button(container, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)zoomToFitButton);
        zoomToFitButton.setText("F&it by content");
        zoomToFitButton.setSelection(this.exportModel.fitContentToPageMargins);
        zoomToFitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.exportModel.fitContentToPageMargins = zoomToFitButton.getSelection();
            }
        });
        final Button attachWikiButton = new Button(container, 32);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)attachWikiButton);
        attachWikiButton.setText("Attach &Wiki page");
        attachWikiButton.setSelection(this.exportModel.attachWiki);
        attachWikiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDFExportPage.this.exportModel.attachWiki = attachWikiButton.getSelection();
            }
        });
        this.setControl((Control)container);
        this.validatePage();
        this.scheduleInitializeData(this.exportModel.selection);
    }

    private void scheduleInitializeData(final NamedResource modelSelection) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PDFExportPage.this.filter.isDisposed()) {
                    return;
                }
                try {
                    PDFExportPage.this.initializeData(modelSelection);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private NamedResource getSelectedModel() {
        int sel = this.modelSelector.getSelectionIndex();
        if (sel != -1) {
            NamedResource nr = (NamedResource)this.modelSelector.getData("" + sel);
            return nr;
        }
        return null;
    }

    private void setExportLocationWithoutNotification(String text) {
        this.exportLocation.removeModifyListener(this.exportLocationListener);
        this.exportLocation.setText(text);
        this.exportLocation.addModifyListener(this.exportLocationListener);
    }

    private Collection<Node> getVisibleNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayDeque<TreeItem> todo = new ArrayDeque<TreeItem>();
        TreeItem[] treeItemArray = this.tree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            todo.add(ti);
            ++n2;
        }
        while (!todo.isEmpty()) {
            TreeItem item = (TreeItem)todo.removeLast();
            Node node = (Node)item.getData();
            result.add(node);
            TreeItem[] treeItemArray2 = item.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                todo.add(child);
                ++n4;
            }
        }
        return result;
    }

    private void resetFilterString(String filterString) {
        String patternString = this.filterStrategy.toPatternString(filterString);
        this.matcher = patternString == null ? null : Pattern.compile(patternString).matcher("");
        this.refreshAndExpandTree();
    }

    private void refreshAndExpandTree() {
        this.tree.refresh();
        this.tree.expandAll();
    }

    private void initializeData(final NamedResource modelSelection) throws DatabaseException, InvocationTargetException, InterruptedException {
        if (modelSelection != null) {
            long time = System.nanoTime();
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Searching for exportable diagrams...", (int)100);
                            PDFExportPage.this.exportModel.sessionContext.getSession().syncRequest((Read)new ReadRequest(){

                                public void run(ReadGraph graph) throws DatabaseException {
                                    (this).PDFExportPage.this.exportModel.nodes = DiagramPrinter.browse((IProgressMonitor)mon.newChild(100), (RequestProcessor)graph, new Resource[]{modelSelection.getResource()});
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            long endTime = System.nanoTime();
            if (this.exportModel.nodes != null) {
                System.out.println("Found " + this.exportModel.nodes.diagrams.size() + " diagrams in " + (double)(endTime - time) * 1.0E-9 + " seconds.");
            }
        }
        if (this.exportModel.nodes == null) {
            return;
        }
        this.selectedNodes.clear();
        this.selectedNodes.addAll(this.exportModel.nodes.breadthFirstFlatten());
        this.tree.setInput((Object)this);
        for (Node root : this.exportModel.nodes.roots) {
            this.tree.setSubtreeChecked((Object)root, true);
        }
        this.resetFilterString(this.filter.getText());
        this.modelSelector.removeSelectionListener(this.modelSelectorListener);
        int selectedIndex = -1;
        int i = 0;
        while (i < this.modelSelector.getItemCount()) {
            Object obj = this.modelSelector.getData("" + i);
            if (ObjectUtils.objectEquals((Object)obj, (Object)modelSelection)) {
                selectedIndex = i;
            }
            ++i;
        }
        if (selectedIndex == -1 && this.modelSelector.getItemCount() > 0) {
            selectedIndex = 0;
        }
        if (selectedIndex != -1) {
            this.modelSelector.select(selectedIndex);
        }
        this.modelSelector.addSelectionListener(this.modelSelectorListener);
        this.validatePage();
    }

    void validatePage() {
        String exportLoc;
        if (this.selectedNodes.size() == 0) {
            this.setMessage("Select the diagrams to export.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (!this.exportLocationTouchedByUser) {
            String generatedName = null;
            NamedResource nr = this.getSelectedModel();
            if (nr != null) {
                generatedName = this.selectedNodes.size() == 1 ? String.valueOf(nr.getName()) + "-" + this.selectedNodes.iterator().next().getName() : nr.getName();
            }
            if (generatedName != null) {
                String name;
                block13: {
                    if (!FileUtils.isValidFileName(generatedName)) {
                        generatedName = (String)Bindings.STR_VARIANT.createUnchecked((Binding)Bindings.STRING, (Object)generatedName);
                    }
                    name = String.valueOf(generatedName) + ".pdf";
                    if (!this.exportModel.recentLocations.isEmpty()) {
                        for (String loc : this.exportModel.recentLocations) {
                            if (!loc.endsWith(name) || loc.equals(name)) continue;
                            name = loc;
                            break block13;
                        }
                        String firstLine = this.exportModel.recentLocations.iterator().next();
                        File f = new File(firstLine);
                        File parentFile = f.getParentFile();
                        if (parentFile != null) {
                            name = new File(f.getParentFile(), name).getAbsolutePath();
                        }
                    }
                }
                this.setExportLocationWithoutNotification(name);
            }
        }
        if ((exportLoc = this.exportLocation.getText()).isEmpty()) {
            this.setMessage("Select an export target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.setErrorMessage("The target already exists and it is a directory.");
                this.setPageComplete(false);
                return;
            }
            if (!file.isFile()) {
                this.setErrorMessage("The target already exists and it is a not a regular file.");
                this.setPageComplete(false);
                return;
            }
        }
        this.exportModel.exportLocation = file;
        int diagramCount = 0;
        for (Node n : this.selectedNodes) {
            if (n.getDiagramResource() == null) continue;
            ++diagramCount;
        }
        String msg = String.valueOf(diagramCount) + " diagrams selected for export.";
        this.setMessage(msg);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

