/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ToggleFocusabilityHandler {
    @CanExecute
    public boolean canExecute(@Active MPart part) {
        if (!(part.getObject() instanceof CompatibilityEditor)) {
            return false;
        }
        CompatibilityEditor editor = (CompatibilityEditor)part.getObject();
        return editor.getPart() instanceof DiagramEditor;
    }

    @Execute
    public void execute(@Optional MToolItem toolItem) {
        ILayersEditor le = this.getLayers();
        if (le != null) {
            boolean b = le.getIgnoreFocusSettings();
            le.setIgnoreFocusSettings(!b);
            if (toolItem != null) {
                toolItem.setSelected(!b);
                toolItem.setTooltip(String.valueOf(!b ? "Deny" : "Allow") + " Focusing and Editing of Images");
            }
        }
    }

    protected ILayersEditor getLayers() {
        DiagramEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return this.getLayers(editor);
    }

    protected ILayersEditor getLayers(DiagramEditor editor) {
        IDiagram diagram = editor.getAdapter(IDiagram.class);
        if (diagram == null) {
            return null;
        }
        ILayersEditor le = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        return le;
    }

    protected DiagramEditor getEditor() {
        IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)editorPart;
            return editor;
        }
        return null;
    }
}

