/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.renaming;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.modeling.ui.diagram.renaming.ComponentsRenamingModel;
import org.simantics.modeling.ui.diagram.renaming.NameEntry;
import org.simantics.utils.ui.ISelectionUtils;

public class ComponentsRenamingDialog
extends Dialog {
    ComponentsRenamingModel model;
    Composite area;
    Label oldNamePrefixLabel;
    Text oldNamePrefix;
    Text newNamePrefix;
    Label errorLabel;
    Text error;
    CheckboxTableViewer tableViewer;

    public ComponentsRenamingDialog(Shell parentShell, ComponentsRenamingModel model) {
        super(parentShell);
        this.model = model;
        this.setShellStyle(48);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Rename diagram contents");
        this.getShell().setLayout((Layout)new GridLayout());
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.area = new Composite(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.area);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).applyTo(this.area);
        this.oldNamePrefixLabel = new Label(this.area, 0);
        this.oldNamePrefixLabel.setText("Old name prefix:");
        this.oldNamePrefix = new Text(this.area, 2056);
        this.oldNamePrefix.setEditable(false);
        this.oldNamePrefix.setText(this.model.oldNamePrefix);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.oldNamePrefix);
        Label newNamePrefixLabel = new Label(this.area, 0);
        newNamePrefixLabel.setText("&New name prefix:");
        this.newNamePrefix = new Text(this.area, 2048);
        this.newNamePrefix.setText(this.model.oldNamePrefix);
        this.newNamePrefix.setSelection(this.model.oldNamePrefix.length());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.newNamePrefix);
        this.newNamePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ComponentsRenamingDialog.this.newNamePrefix.getText();
                if (ComponentsRenamingDialog.this.model.prefixValidator != null) {
                    String err = (String)ComponentsRenamingDialog.this.model.prefixValidator.apply((Object)text);
                    if (err != null) {
                        if (ComponentsRenamingDialog.this.error == null) {
                            ComponentsRenamingDialog.this.errorLabel = new Label(ComponentsRenamingDialog.this.area, 0);
                            ComponentsRenamingDialog.this.errorLabel.moveBelow((Control)ComponentsRenamingDialog.this.newNamePrefix);
                            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)ComponentsRenamingDialog.this.errorLabel);
                            ComponentsRenamingDialog.this.error = new Text(ComponentsRenamingDialog.this.area, 74);
                            ComponentsRenamingDialog.this.error.moveBelow((Control)ComponentsRenamingDialog.this.errorLabel);
                            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ComponentsRenamingDialog.this.error);
                            ComponentsRenamingDialog.this.error.setForeground(ComponentsRenamingDialog.this.error.getDisplay().getSystemColor(3));
                        }
                        ComponentsRenamingDialog.this.error.setText(err);
                        ComponentsRenamingDialog.this.area.getParent().layout();
                        ComponentsRenamingDialog.this.getButton(0).setEnabled(false);
                        return;
                    }
                    if (ComponentsRenamingDialog.this.error != null) {
                        ComponentsRenamingDialog.this.errorLabel.dispose();
                        ComponentsRenamingDialog.this.errorLabel = null;
                        ComponentsRenamingDialog.this.error.dispose();
                        ComponentsRenamingDialog.this.error = null;
                        ComponentsRenamingDialog.this.area.getParent().layout();
                        ComponentsRenamingDialog.this.getButton(0).setEnabled(true);
                    }
                }
                ComponentsRenamingDialog.this.model.newNamePrefix = text;
                ComponentsRenamingDialog.this.model.computeNewNames();
                ComponentsRenamingDialog.this.refresh();
            }
        });
        final Button resetNames = new Button(composite, 32);
        resetNames.setText("&Reset names");
        resetNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsRenamingDialog.this.model.reset = resetNames.getSelection();
                ComponentsRenamingDialog.this.model.computeNewNames();
                ComponentsRenamingDialog.this.refresh();
            }
        });
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2818);
        this.tableViewer.getTable().setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableViewer.getTable());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ComponentsRenamingDialog.this.model.selectedEntries.contains(element);
            }
        });
        TableViewerColumn oldNameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        oldNameColumn.getColumn().setText("Old name");
        oldNameColumn.getColumn().setWidth(250);
        oldNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameEntry entry = (NameEntry)element;
                return entry.oldName;
            }
        });
        TableViewerColumn newNameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        newNameColumn.getColumn().setText("New name");
        newNameColumn.getColumn().setWidth(250);
        newNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameEntry entry = (NameEntry)element;
                return entry.newName;
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            void addOrRemoveSelection(NameEntry entry, boolean add) {
                if (add) {
                    ComponentsRenamingDialog.this.model.selectedEntries.add(entry);
                } else {
                    ComponentsRenamingDialog.this.model.selectedEntries.remove(entry);
                }
            }

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                NameEntry checkedNode = (NameEntry)event.getElement();
                HashSet<NameEntry> entries = new HashSet<NameEntry>();
                Set selection = ISelectionUtils.filterSetSelection((Object)ComponentsRenamingDialog.this.tableViewer.getSelection(), NameEntry.class);
                if (selection.contains(checkedNode)) {
                    entries.addAll(selection);
                } else {
                    ComponentsRenamingDialog.this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                entries.add(checkedNode);
                for (NameEntry entry : entries) {
                    this.addOrRemoveSelection(entry, checked);
                }
                ComponentsRenamingDialog.this.tableViewer.refresh();
            }
        });
        this.tableViewer.setInput((Object)this.model.entries.toArray());
        this.newNamePrefix.setFocus();
        Composite bar = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)bar);
        bar.setLayout((Layout)new RowLayout());
        Button selectAll = new Button(bar, 8);
        selectAll.setText("Select &All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsRenamingDialog.this.model.selectedEntries.addAll(ComponentsRenamingDialog.this.model.entries);
                ComponentsRenamingDialog.this.tableViewer.setAllChecked(true);
            }
        });
        Button clearSelection = new Button(bar, 8);
        clearSelection.setText("&Clear Selection");
        clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentsRenamingDialog.this.model.selectedEntries.clear();
                ComponentsRenamingDialog.this.tableViewer.setAllChecked(false);
            }
        });
        return composite;
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.open();
        ComponentsRenamingModel model = new ComponentsRenamingModel();
        model.oldNamePrefix = "FOO";
        model.newNamePrefix = "FOO";
        int i = 0;
        while (i < 100) {
            model.entries.add(new NameEntry(null, "FOO" + i * 5, "FOO" + i * 5, "PREFIX"));
            ++i;
        }
        ComponentsRenamingDialog dialog = new ComponentsRenamingDialog(shell, model);
        dialog.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

