/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableWriteImplied;

public class MonitorVariableWrite
extends WriteRequest {
    private final Variable variable;
    private final String label;

    public MonitorVariableWrite(Variable variable, String label) {
        super(null);
        this.variable = variable;
        this.label = label;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Variable converted = this.variable.getPossibleProperty((ReadGraph)graph, "convertedValue");
        if (converted != null) {
            converted.setValue(graph, (Object)this.label, (Binding)Bindings.STRING);
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)this.label)));
        } else {
            new VariableWriteImplied(this.variable, this.label).perform(graph);
        }
    }
}

