/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.representation.PrettyPrintTG;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;

public class PGraphEditorDocumentProvider
extends AbstractDocumentProvider {
    protected Resource resource;
    protected String currentText;
    protected boolean errorHappened;
    protected AnnotationModel annotationModel = new AnnotationModel();
    boolean annotationsInitialized = false;

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(PGraphEditorDocumentProvider.this.resource, L0.PGraph)) {
                        PGraphEditorDocumentProvider.this.currentText = (String)graph.getRelatedValue(PGraphEditorDocumentProvider.this.resource, L0.PGraph_definition, (Binding)Bindings.STRING);
                        PGraphEditorDocumentProvider.this.errorHappened = false;
                        return new Document(PGraphEditorDocumentProvider.this.currentText != null ? PGraphEditorDocumentProvider.this.currentText : "");
                    }
                    Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(PGraphEditorDocumentProvider.this.resource));
                    try {
                        if (indexRoot != null && graph.isInstanceOf(indexRoot, L0.Ontology)) {
                            TransferableGraph1 tg = ModelingUtils.exportSharedOntology((ReadGraph)graph, (Resource)indexRoot, null, (String)"sharedLibrary", (int)1);
                            GraphRefactoringUtils.fixOntologyExport((TransferableGraph1)tg);
                            PGraphEditorDocumentProvider.this.currentText = PrettyPrintTG.print((TransferableGraph1)tg);
                            PGraphEditorDocumentProvider.this.errorHappened = false;
                        }
                        return new Document(PGraphEditorDocumentProvider.this.currentText != null ? PGraphEditorDocumentProvider.this.currentText : "");
                    }
                    catch (Exception exception) {
                        throw new DatabaseException("Could not get PGraph from " + PGraphEditorDocumentProvider.this.resource);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                PGraphEditorDocumentProvider.this.setAnnotations(Collections.emptyList());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(List<CompilationError> errors) {
        Object object = this.annotationModel.getLockObject();
        synchronized (object) {
            this.annotationModel.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation("org.eclipse.ui.workbench.texteditor.error", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                Position position = new Position(begin, end - begin);
                this.annotationModel.addAnnotation(annotation, position);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (!this.annotationsInitialized) {
            this.updateAnnotations();
            this.annotationsInitialized = true;
        }
        return this.annotationModel;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog((String)"PGraphEditorDocumentProvider.doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                graph.claimLiteral(PGraphEditorDocumentProvider.this.resource, L0.PGraph_definition, (Object)PGraphEditorDocumentProvider.this.currentText, (Binding)Bindings.STRING);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved Ontology Definition File " + graph.getRelatedValue2(PGraphEditorDocumentProvider.this.resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened;
    }
}

