/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.ui.SimanticsUI;

public class NewSVGImage implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                SimanticsUI.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                    	createNewSVGImage(g, parent);
                    }
                });
            }
        };
    }
    
    public static Resource createNewSVGImage(WriteGraph g, Resource parent) throws DatabaseException {
    	
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);
        G2DResource G2D = G2DResource.getInstance(g);
        ScenegraphResources SG = ScenegraphResources.getInstance(g);

        Resource ref = g.newResource();
        g.claim(ref, L0.InstanceOf, null, TEMPLATE2D.Profiles_VariableReference);
        // This works only when experiment is running!
        g.claimLiteral(ref, TEMPLATE2D.Profiles_VariableReference_path, "", Bindings.STRING);

        Resource svgImage = g.newResource();
        g.claim(svgImage, L0.InstanceOf, null, DIA.Scenegraph_SVGImage);
        String name = NameUtils.findFreshName(g, "Image", parent, L0.ConsistsOf);
        g.addLiteral(svgImage, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
        g.claim(svgImage, DIA.Scenegraph_SVGImage_document, ref);
        g.addLiteral(svgImage, DIA.Scenegraph_SVGImage_transform, DIA.Scenegraph_SVGImage_transform_Inverse, G2D.Transform, new Double[] { 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 }, Bindings.getBindingUnchecked(Double[].class));
        g.claim(svgImage, L0.PartOf, parent);
        Resource list = g.getPossibleObject(parent, SG.Node_children);
        if (list != null)
        	ListUtils.insertBack(g, list, Arrays.asList(svgImage));
    	return svgImage;
    }
}
