package org.simantics.ltk.antlr;

import java.io.IOException;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Location;
import org.simantics.ltk.Problem;

public class ANTLRUtils {

	public static void setUpParser(ISource source, Lexer lexer, Parser parser) throws IOException {
		CharStream stream = new ANTLRInputStream(source.open());
		lexer.setCharStream(stream);
		parser.setTokenStream(new CommonTokenStream(lexer));
	}
	
	public static Location location(ISource source, Tree tree) {
		return new Location(source, 
				getStartLine(tree), 
				getStartIndex(tree), 
				getStopIndex(tree)+1
			);
	}
	
	public static int getStartLine(Tree tree) {
		Token payload = ((CommonTree)tree).token;
		int startLine = payload != null && payload.getTokenIndex() >= 0 ?
				((CommonToken)payload).getLine()
				: Integer.MAX_VALUE;
		int count = tree.getChildCount();
		for(int i=0;i<count;++i) {
			Tree child = tree.getChild(i);
			int temp = getStartLine(child);
			if(temp < startLine)
				startLine = temp;
		}
		return startLine;
	}
	
	public static int getStartIndex(Tree tree) {
		Token payload = ((CommonTree)tree).token;
		int startIndex = payload != null && payload.getTokenIndex() >= 0 ?
				((CommonToken)payload).getStartIndex()
				: Integer.MAX_VALUE;
		int count = tree.getChildCount();
		for(int i=0;i<count;++i) {
			Tree child = tree.getChild(i);
			int temp = getStartIndex(child);
			if(temp < startIndex)
				startIndex = temp;
		}
		return startIndex;
	}
	
	public static int getStopIndex(Tree tree) {
		Token payload = ((CommonTree)tree).token;
		int stopIndex =  payload != null && payload.getTokenIndex() >= 0 ?
				((CommonToken)payload).getStopIndex()
				: 0;
		int count = tree.getChildCount();
		for(int i=0;i<count;++i) {
			Tree child = tree.getChild(i);
			int temp = getStopIndex(child);
			if(temp > stopIndex)
				stopIndex = temp;
		}
		return stopIndex;
	}
	
	public static Location location(ISource source, Token token) {
		return new Location(source, 
				token.getLine(),
				((CommonToken) token).getStartIndex(), 
				((CommonToken) token).getStopIndex()+1
			);
	}

	public static Problem error(ISource source, RecognitionException e, Parser parser) {
		return new Problem(location(source, e.token),
				parser.getErrorMessage(e, parser.getTokenNames()));
	}

	public static Problem error(ISource source, RecognitionException e,	Lexer lexer) {
		return new Problem(new Location(source, e.line, e.index, e.index+1),
				lexer.getErrorMessage(e, lexer.getTokenNames()));
	}	
}
