/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.history.examples;

import java.io.File;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.utils.FileUtils;

public class HistoryExample2 {
		
	public static void main(String[] args) throws Exception {
		
		//// Create sampling formats		
		// Simple format captures all samples, no min/max/avg/median 
		SamplingFormat simpleFormat, intervalFormat;
		simpleFormat = new SamplingFormat();
		RecordType format = (RecordType) (simpleFormat.format = new RecordType());
		format.addComponent("time", Datatypes.DOUBLE);
		format.addComponent("value", Datatypes.DOUBLE );
		format.addComponent("quality", Datatypes.BYTE );
		simpleFormat.interval = Double.NaN;
		simpleFormat.deadband = Double.NaN;
		simpleFormat.formatId = "Simple";
		
		// Interval format captures samples with 0.5s interval. It also calculates min/max/avg/median 
		intervalFormat = new SamplingFormat();
		format = (RecordType) (intervalFormat.format = new RecordType());
		format.addComponent("time", Datatypes.DOUBLE);
		format.addComponent("endTime", Datatypes.DOUBLE);
		format.addComponent("value", Datatypes.DOUBLE );
		format.addComponent("lastValue", Datatypes.DOUBLE);		
		format.addComponent("min", Datatypes.DOUBLE);
		format.addComponent("max", Datatypes.DOUBLE);
		format.addComponent("avg", Datatypes.DOUBLE);
		format.addComponent("median", Datatypes.DOUBLE);
		format.addComponent("quality", Datatypes.BYTE );
		format.addComponent("count", Datatypes.INTEGER);
		intervalFormat.interval = Double.NaN;
		intervalFormat.deadband = Double.NaN;
		intervalFormat.interval = 0.5;
		intervalFormat.formatId = "Interval";
		
		//// Create item descriptions
		SubscriptionItem[] items = SubscriptionItem.createItems("Variable", "MySubscription", simpleFormat, intervalFormat);

		// Manage items
		ItemManager im = new ItemManager( items );
		im.search("groupId", "MySubscription");
		
		//// Open file history & initialize subscription 
		File workarea = FileUtils.createTmpDir();
		HistoryManager historian = History.openFileHistory( workarea );
		historian.create( items );
				
		//// Record data
		Collector collector = new CollectorImpl( historian );
		collector.addItems( items );
		try {
			double NaN = Double.NaN;
			double[] data = { 5.0, 5.0, 5.0, 5.0, 6.0, 6.0, 6.0, 7.0, 8.0, 9.0, NaN,10.0, NaN, NaN, NaN };

			for (int i=0; i<data.length; i++) 
			{
				collector.beginStep(Bindings.DOUBLE, i * 0.1);
				collector.setValue("Variable", Bindings.DOUBLE, data[i]);
				collector.endStep();
			}
			
		} finally {
			collector.close();
		}
		
		// Open accessor to the data, read & print data.
		System.out.println("IntervalFormat = "+intervalFormat.toString());
		StreamAccessor sa = historian.openStream( items[1].id, "r" );
		try {			
			sa.reset();
			Datatype sampleType = sa.type().componentType;
			Binding beanBinding = Bindings.getBeanBinding( sampleType );
			Bean sample = (Bean) beanBinding.createDefault();
			for (int i=0; i<sa.size(); i++) {
				sa.get(i, beanBinding, sample);
				System.out.println( sample );
			}
		} finally {
			sa.close();
		}
				
		// The data can also be read using generic binding
		System.out.println("\nSimpleFormat = "+simpleFormat.toString());
		sa = historian.openStream(items[0].id, "r");
		try {			
			sa.reset();
			Binding b = Bindings.getBinding( simpleFormat.format );
			Object sample = b.createDefault();
			for (int i=0; i<sa.size(); i++) {
				sa.get(i, b, sample);
				System.out.println( b.toString(sample) );
			}
		} finally {
			sa.close();
		}
		
		
	}

}
