package org.simantics.history.examples;

import java.util.UUID;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.StreamAccessor;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryAndCollectorItem;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryItem;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.FlushPolicy;

public class CollectorExample1 {

	public static void main(String[] args) throws HistoryException, BindingException, AccessorException {
		
		/// Example1: Create History Manager & Item
		// Create History Manager
		HistoryManager history = History.createMemoryHistory();
		
		// Create a sample format
		RecordType sampleFormat = new RecordType();
		sampleFormat.addComponent("time", Datatypes.DOUBLE );
		sampleFormat.addComponent("value", Datatypes.DOUBLE );
		sampleFormat.addComponent("quality", Datatypes.BYTE );
		
		// Create History Item configuration
		String id = UUID.randomUUID().toString();
		HistoryItem historyItem = new HistoryItem(id, sampleFormat);
		
		// Create the item in the history
		history.create( historyItem );
		
		
		
		

		/// Example2: Prepare Collector
		Collector collector = History.createCollector(history, FlushPolicy.NoFlush);
		
		// Read item configuration data from history ( id and sampleFormat )
		Bean hi = history.getItem( id );
		
		// Create collector item
		HistoryAndCollectorItem ci = new HistoryAndCollectorItem();
		ci.readAvailableFields( hi ); // Read: id, sampleFormat
		ci.interval = 0.5;
		//ci.deadband = 10;
		ci.enabled = true;
		ci.gain = 10.0;
		ci.variableId = "MyItem";
		
		// Initialize Collector (Item)
		collector.addItem( ci );
		
		try {
			// Simulate 100 steps
			for ( int i = 0; i<100; i++ ) {
				
				// Our "simulation" results 
				double time = i * 0.1;
				double myItemValue = -20 + i*0.1;
				
				// Begin collector writing step
				collector.beginStep(Bindings.DOUBLE, time);
				
				// Enter values 
				collector.setValue("MyItem", Bindings.DOUBLE, myItemValue);
				
				// End collector step
				collector.endStep();
			}
			
		} finally {
			// Flush values
			collector.flush();
			collector.close();
		}
		
		
		
		/// Print results
		// Open stream from history
		StreamAccessor aa = history.openStream(id, "r");
		// Read sample type
		RecordType sampleType = (RecordType) aa.type().componentType;
		// Create bean binding
		RecordBinding sampleBinding = (RecordBinding) Bindings.getBeanBinding( sampleType );
		// Create sample object
		Bean sample = (Bean) sampleBinding.createPartial();
		
		try {
			for (int i=0; i<aa.size(); i++) {
				aa.get(i, sampleBinding, sample);
				System.out.println(i+": "+sample);
			}
		} finally {
			aa.close();
		}
		
	}
	
}
