/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fileimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.databoard.util.Base64;
import org.simantics.db.Resource;
import org.simantics.fileimport.Activator;
import org.simantics.fileimport.IGenericFileImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileImportService.class);
    public static final String DB_FILE = ".simanticsdb";
    static final String FOLDER = "_folder_";

    private FileImportService() {
    }

    private static List<IGenericFileImport> getFileImportServices() {
        ServiceReference[] serviceReferences = new ServiceReference[]{};
        try {
            serviceReferences = Activator.getContext().getAllServiceReferences(IGenericFileImport.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Could not get service references for IGenericFileImport!", (Throwable)e);
        }
        if (serviceReferences.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IGenericFileImport> services = new ArrayList<IGenericFileImport>(serviceReferences.length);
        ServiceReference[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference reference = serviceReferenceArray[n2];
            IGenericFileImport service = (IGenericFileImport)Activator.getContext().getService(reference);
            services.add(service);
            ++n2;
        }
        return services;
    }

    public static Map<String, String> supportedExtensionsWithFilters() {
        List<IGenericFileImport> services = FileImportService.getFileImportServices();
        HashMap<String, String> extensionsWithFilters = new HashMap<String, String>();
        for (IGenericFileImport service : services) {
            extensionsWithFilters.putAll(service.allowedExtensionsWithFilters());
        }
        return extensionsWithFilters;
    }

    public static String performFileImport(String base64, String name) throws Throwable {
        byte[] bytes = Base64.decode((String)base64);
        Path file = Activator.getModelsFolder().resolve(name);
        Files.write(file, bytes, new OpenOption[0]);
        ConsumerHolder holder = new ConsumerHolder();
        String result = FileImportService.performFileImport(file, Optional.of(holder));
        if (holder.getThrowable() != null) {
            throw holder.getThrowable();
        }
        return result;
    }

    public static String performFileImport(Path file, Optional<Consumer<Throwable>> callback) {
        String result;
        block7: {
            if (file.getFileName().toString().equals(DB_FILE)) {
                return null;
            }
            result = "Import failed";
            IGenericFileImport service = FileImportService.findServiceForFileExtension(file);
            if (service != null) {
                try {
                    Optional<String> resource = service.perform(file);
                    FileImportService.saveResourceForPath(file, resource);
                    result = resource.get();
                }
                catch (Throwable t) {
                    if (callback.isPresent()) {
                        callback.get().accept(t);
                        break block7;
                    }
                    LOGGER.error("Could not import file " + file, t);
                }
            } else {
                LOGGER.warn("Could not find service for importing file " + file);
                if (callback.isPresent()) {
                    callback.get().accept(new Exception("Could not find IGenericFileImport service for file " + file));
                }
            }
        }
        return result;
    }

    public static void removeResourceForFile(Path file, Optional<Consumer<Throwable>> callback) {
        try {
            Optional<String> resource = FileImportService.getResourceForPath(file);
            if (!resource.isPresent()) {
                return;
            }
            IGenericFileImport service = FileImportService.findServiceForFileExtension(file);
            if (service == null) {
                LOGGER.warn("Could not find service for importing file " + file);
                if (callback.isPresent()) {
                    callback.get().accept(new Exception("Could not find IGenericFileImport service for file " + file));
                }
            }
            service.remove(resource.get());
            FileImportService.removeResourceForPath(file);
        }
        catch (Throwable t) {
            if (callback.isPresent()) {
                callback.get().accept(t);
            }
            LOGGER.error("Could not remove resource for file " + file.toAbsolutePath(), t);
        }
    }

    public static void removeFileForResource(long id, Optional<Consumer<Throwable>> callback) {
        Optional<Path> fileOp;
        try {
            fileOp = FileImportService.findPathForId(id);
        }
        catch (IOException e) {
            LOGGER.error("Could not remove file for resource id " + id, (Throwable)e);
            return;
        }
        if (!fileOp.isPresent()) {
            return;
        }
        Path file = fileOp.get();
        try {
            Optional<String> resource = FileImportService.getResourceForPath(file);
            if (!resource.isPresent()) {
                return;
            }
            IGenericFileImport service = FileImportService.findServiceForFileExtension(file);
            if (service == null) {
                LOGGER.warn("Could not find service for importing file " + file);
                if (callback.isPresent()) {
                    callback.get().accept(new Exception("Could not find IGenericFileImport service for file " + file));
                }
            }
            service.remove(resource.get());
            FileImportService.removeResourceForPath(file);
            try {
                Files.delete(file);
            }
            catch (IOException iOException) {
                Files.delete(file);
            }
        }
        catch (Throwable t) {
            if (callback.isPresent()) {
                callback.get().accept(t);
            }
            LOGGER.error("Could not remove file for resource " + id, t);
        }
    }

    private static Optional<Path> findPathForId(long id) throws IOException {
        Path db = Activator.getDropinsFolder().resolve(DB_FILE);
        if (!Files.exists(db, new LinkOption[0])) {
            Files.createFile(db, new FileAttribute[0]);
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Iterator<Map.Entry<Object, Object>> iterator = null;
        try (InputStream stream = Files.newInputStream(db, new OpenOption[0]);){
            props.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Long value = Long.valueOf(entry.getValue().toString());
            if (value != id) continue;
            String key = (String)entry.getKey();
            return Optional.of(Paths.get(key, new String[0]));
        }
        return Optional.empty();
    }

    public static IGenericFileImport findServiceForFileExtension(Path file) {
        String extension = "";
        int i = file.getFileName().toString().lastIndexOf(46);
        if (i > 0) {
            extension = file.getFileName().toString().substring(i);
        } else if (Files.isDirectory(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0])) {
            extension = FOLDER;
        }
        return FileImportService.findServiceForExtension(extension);
    }

    public static List<String> filterSupportedExtensions(String filter) {
        return FileImportService.getFileImportServices().stream().filter(s -> s.allowedExtensionsWithFilters().keySet().contains(filter)).map(s -> s.allowedExtensionsWithFilters().keySet()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static IGenericFileImport findServiceForExtension(String extension) {
        List<IGenericFileImport> services = FileImportService.findServicesForExtension(extension);
        IGenericFileImport service = null;
        if (services.size() == 1) {
            service = services.get(0);
        } else {
            Iterator<IGenericFileImport> iterator = services.iterator();
            while (iterator.hasNext()) {
                IGenericFileImport servicee;
                service = servicee = iterator.next();
                if (FileImportService.isPerfectMatch(servicee.allowedExtensionsWithFilters().keySet(), extension)) break;
            }
        }
        return service;
    }

    public static List<IGenericFileImport> findServicesForExtension(String extension) {
        ArrayList<IGenericFileImport> result = new ArrayList<IGenericFileImport>();
        List<IGenericFileImport> services = FileImportService.getFileImportServices();
        for (IGenericFileImport service : services) {
            for (Map.Entry<String, String> entry : service.allowedExtensionsWithFilters().entrySet()) {
                String possibleExtensions = entry.getKey();
                if (possibleExtensions.startsWith("*")) {
                    possibleExtensions = possibleExtensions.substring(1);
                }
                if (!possibleExtensions.equals(extension) && !possibleExtensions.isEmpty()) continue;
                if (extension.equals(FOLDER) && possibleExtensions.equals(FOLDER)) {
                    result.add(service);
                    continue;
                }
                if (extension.isEmpty() || extension.equals(FOLDER)) continue;
                result.add(service);
            }
        }
        return result;
    }

    public static Map<String, String> getPathsAndResources() {
        try {
            Path db = Activator.getDropinsFolder().resolve(DB_FILE);
            if (!Files.exists(db, new LinkOption[0])) {
                Files.createFile(db, new FileAttribute[0]);
            }
            Properties props = new Properties();
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = Files.newInputStream(db, new OpenOption[0]);){
                props.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String value = (String)entry.getValue();
                String key = (String)entry.getKey();
                map.put(key, value);
            }
            return map;
        }
        catch (IOException e) {
            LOGGER.error("Could not get current paths and resources!", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static void saveResourceForPath(Path file, Optional<String> resource) {
        resource.ifPresent(res -> {
            try {
                Closeable stream;
                Path db = Activator.getDropinsFolder().resolve(DB_FILE);
                if (!Files.exists(db, new LinkOption[0])) {
                    Files.createFile(db, new FileAttribute[0]);
                }
                Properties props = new Properties();
                Throwable throwable = null;
                Object var6_9 = null;
                try {
                    stream = Files.newInputStream(db, new OpenOption[0]);
                    try {
                        props.load((InputStream)stream);
                    }
                    finally {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                props.put(file.getFileName().toString(), resource.get());
                throwable = null;
                var6_9 = null;
                try {
                    stream = Files.newOutputStream(db, new OpenOption[0]);
                    try {
                        props.store((OutputStream)stream, null);
                    }
                    finally {
                        if (stream != null) {
                            ((OutputStream)stream).close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not save resource for path " + file.toAbsolutePath() + " and resource " + (String)resource.get(), (Throwable)e);
            }
        });
    }

    private static void removeResourceForPath(Path file) throws IOException {
        Closeable stream;
        Path db = Activator.getDropinsFolder().resolve(DB_FILE);
        if (!Files.exists(db, new LinkOption[0])) {
            Files.createFile(db, new FileAttribute[0]);
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            stream = Files.newInputStream(db, new OpenOption[0]);
            try {
                props.load((InputStream)stream);
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        props.remove(file.getFileName().toString());
        throwable = null;
        var4_6 = null;
        try {
            stream = Files.newOutputStream(db, new OpenOption[0]);
            try {
                props.store((OutputStream)stream, null);
            }
            finally {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static Optional<String> getResourceForPath(Path file) throws IOException {
        Path db = Activator.getDropinsFolder().resolve(DB_FILE);
        if (!Files.exists(db, new LinkOption[0])) {
            Files.createFile(db, new FileAttribute[0]);
        }
        Properties props = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = Files.newInputStream(db, new OpenOption[0]);){
            props.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String value = props.getProperty(file.getFileName().toString());
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static String importGenericFileWithExtension(String path, String extension) throws Exception {
        IGenericFileImport service = FileImportService.findServiceForExtension(extension);
        Optional<String> result = service.perform(Paths.get(path, new String[0]));
        return result.get();
    }

    public static Resource importGenericFileWithExtensionAndParent(Resource parent, String path, String extension) throws Exception {
        IGenericFileImport service = FileImportService.findServiceForExtension(extension);
        Optional<Resource> result = service.perform(parent, Paths.get(path, new String[0]));
        return result.get();
    }

    private static boolean isPerfectMatch(Set<String> candidates, String extension) {
        for (String ext : candidates) {
            if (ext.startsWith("*")) {
                ext = ext.substring(1);
            }
            if (!ext.equals(extension)) continue;
            return true;
        }
        return false;
    }

    private static class ConsumerHolder
    implements Consumer<Throwable> {
        private Throwable throwable;

        private ConsumerHolder() {
        }

        @Override
        public void accept(Throwable t) {
            this.throwable = t;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

